# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

#def_with slideshow

%define theme platform-builder
%define Theme Platform Builder
%define codename Salvia
%define brand alt
%define Brand ALT
%define flavour %brand-%theme
%define distro_name alt-platform-builder
%define distro_name_ru alt-platform-builder
%define branding_data_dir %_datadir/branding-data-current
%define altbranch %_priority_distbranch
%define Brand_ru Альт

Name: branding-%flavour
Version: 11.0
Release: alt0.p11.1

Url: https://www.basealt.ru/platform

BuildRequires(pre): rpm-macros-branding

BuildRequires: cpio fonts-ttf-dejavu fonts-ttf-google-droid-sans

BuildRequires: qt5-base-devel
BuildRequires: libalternatives-devel

BuildRequires: ImageMagick fontconfig bc libGConf-devel
BuildRequires: fribidi

BuildRequires: distro-licenses

%define status %nil
%define status_en %nil

# argh
%define design_graphics_abi_epoch 0
%define design_graphics_abi_major 12
%define design_graphics_abi_minor 0
%define design_graphics_abi_bugfix 0

Source: branding.tar

Group: Graphics
Summary: System/Base
License: GPL-2.0-or-later

%description
Distro-specific packages with design and texts

%package alterator
Summary: Design for alterator for %Brand %Theme
License: GPL-2.0-or-later
Group: System/Configuration/Other
BuildArch: noarch
Provides: design-alterator-browser-%theme branding-alt-%theme-browser-qt branding-altlinux-%theme-browser-qt
Provides: alterator-icons design-alterator design-alterator-%theme
Obsoletes: branding-alt-%theme-browser-qt branding-altlinux-%theme-browser-qt design-alterator-server design-alterator-desktop design-alterator-browser-desktop design-alterator-browser-server
%branding_add_conflicts %flavour alterator
Requires(post,preun): alternatives >= 0.2 alterator

%description alterator
Design for QT and web alterator for %Brand %Theme

%define provide_list altlinux fedora redhat system altlinux
%define obsolete_list altlinux-release fedora-release redhat-release

%package release
Summary: %distribution %Theme release file
Group: System/Configuration/Other
BuildArch: noarch
Requires: alt-os-release
Provides: %(for n in %provide_list; do echo -n "$n-release = %version-%release "; done) altlinux-release-%theme branding-alt-%theme-release
Obsoletes: %obsolete_list
%branding_add_conflicts %flavour release

%description release
%distribution %version %Theme release file.

%package notes
Provides: alt-license-theme = %version alt-notes-%theme
Obsoletes: alt-license-%theme
Summary: Distribution license and release notes
License: Distributable
Group: Documentation
BuildArch: noarch
%branding_add_conflicts %flavour notes

%description notes
Distribution license and release notes

%package slideshow

Summary: Slideshow for %Brand %version %Theme installer
License: Distributable
Group: System/Configuration/Other
BuildArch: noarch
%branding_add_conflicts %flavour slideshow

%description slideshow
Slideshow for %Brand %version %Theme installer

%package indexhtml

Summary: ALT Linux welcome page
License: distributable
Group: System/Base
BuildArch: noarch
Provides: indexhtml indexhtml-%theme = %version indexhtml-Desktop = 1:5.0
Obsoletes: indexhtml-desktop indexhtml-Desktop
%branding_add_conflicts %flavour indexhtml

Requires: xdg-utils
Requires(post): indexhtml-common

%description indexhtml
ALT Linux index.html welcome page.

%prep
%setup -n branding
cp /usr/share/distro-licenses/ALT_Product_License/license.{all,ru}.html.in notes/

%build
autoconf
THEME=%theme NAME='%Theme' BRAND_FNAME='%Brand' BRAND_FNAME_RU='%Brand_ru' BRAND='%brand' STATUS_EN=%status_en STATUS=%status VERSION=%version PRODUCT_NAME='%distro_name' PRODUCT_NAME_RU='%distro_name_ru' CODENAME=%codename URL='%url' BRANCH='%altbranch' ./configure
LC_ALL=en_US.UTF-8 make

%install
%makeinstall

#release
install -pD -m644 /dev/null %buildroot%_sysconfdir/buildreqs/packages/ignore.d/%name-release
{
	[ -n "%Brand" ] && echo -n "%Brand"
	[ -n "%Theme" ] && echo -n " %Theme"
	[ -n "%version" ] && echo -n " %version"
	[ -n "%status_en" ] && {
		[ "%status_en" = "unstable" ] \
		&& echo -n " (unstable)" \
		|| echo -n " %status_en"
	}
	[ -n "%codename" ] && echo -n " (%codename)"
	echo
} >%buildroot%_sysconfdir/altlinux-release
for n in fedora redhat system; do
	ln -s altlinux-release %buildroot%_sysconfdir/$n-release
done

mkdir -p %buildroot/%prefix/lib/
install -pD -m644 components/systemd/os-release %buildroot/%prefix/lib/os-release

#notes
pushd notes
%makeinstall
popd

%if_with slideshow
#slideshow
mkdir -p %buildroot/usr/share/install2/slideshow
install slideshow/* %buildroot/usr/share/install2/slideshow/
%endif

%post indexhtml
%_sbindir/indexhtml-update

%files alterator
%config %_altdir/*.rcc
/usr/share/alterator-browser-qt/design/*.rcc
/usr/share/alterator/design/*

%files release
%_sysconfdir/buildreqs/packages/ignore.d/*
%_sysconfdir/*-release
%prefix/lib/os-release

%files notes
%_datadir/alt-notes/*

%if_with slideshow
%files slideshow
/usr/share/install2/slideshow
%endif

%define indexhtmldir %_defaultdocdir/indexhtml

%files indexhtml
%ghost %indexhtmldir/index.html
%indexhtmldir/index-*.html
%indexhtmldir/index.css
%indexhtmldir/images
%_desktopdir/indexhtml.desktop

%changelog
