Name: ca-certificates
Version: 2025.09.08
Release: alt1

Summary: Common CA Certificates
License: MPL-2.0
Group: System/Base
BuildArch: noarch

Source0: mozilla.tar
Source1: ca-bundle.trust.p11-kit

BuildRequires: openssl
BuildRequires: python3(base64)
BuildRequires: python3(os)
BuildRequires: python3(re)
BuildRequires: python3(textwrap)
BuildRequires: python3(urllib)
BuildRequires: python3(subprocess)

Requires: ca-trust

%description
This package contains a bundle of X.509 certificates of public
Certificate Authorities (CA).  This is useful for any applications to
verify SSL/TLS connection.

Note that certificate authorities whose certificates are included in
this package are not in any way audited for trustworthiness and RFC3647
compliance, and that full responsibility to assess them rests with the
user.

%prep
%setup -c

%build
export TZ=UTC
pushd mozilla
	python3 ./certdata2pem.py >c2p.log 2>c2p.err
popd
cat %SOURCE1 mozilla/*.tmp-p11-kit > ca-bundle.trust.p11-kit

%install
install -pD -m 644 ca-bundle.trust.p11-kit \
	%buildroot%_datadir/pki/ca-trust-source/ca-bundle.trust.p11-kit

%files
%_datadir/pki/ca-trust-source/ca-bundle.trust.p11-kit

%changelog
