Name: ccnet
Version: 7.1.1
Release: alt1

Summary: Framework for writing networked applications in C

Group: Networking/File transfer
License: GPLv2 with permissions for OpenSSL
Url: https://github.com/haiwen/ccnet-server

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/haiwen/ccnet-server/archive/v%version-server.tar.gz
Source: %name-%version.tar

BuildRequires: libevent-devel libssl-devel libuuid-devel

BuildRequires: libsqlite3-devel

BuildRequires: libsearpc-devel >= 3.2.0

BuildRequires: vala >= 0.8

# TODO: postgresql
BuildRequires: libmysqlclient-devel

BuildRequires: libzdb-devel >= 2.10.2

BuildRequires: rpm-build-python3

#Requires: lib%name = %version-%release

%description
Ccnet is a framework for writing networked applications in C.

%package -n lib%name
Summary: Library of framework for writing networked applications in C
Group: Networking/File transfer
Requires: libsearpc >= 3.2.0


%description -n lib%name
Ccnet is a framework for writing networked applications in C.

%package -n lib%name-devel
Summary: Development files for lib%name
Requires: lib%name = %version-%release
Group: Networking/File transfer

%description -n lib%name-devel
The lib%name-devel package contains libraries and header files for
developing applications that use lib%name.

%package server
Summary: Ccnet server
Requires: lib%name = %version-%release
Requires: %name = %version-%release
Group: Networking/File transfer
Conflicts: %name < %EVR

%description server
Ccnet server part.
Ccnet is a framework for writing networked applications in C.

%package -n python3-module-%name
Summary: Ccnet python module
Requires: lib%name = %version-%release
Group: Networking/File transfer

%description -n python3-module-%name
Ccnet python module.

%prep
%setup
%__subst 's/(DESTDIR)//' libccnet.pc.in
# since MySQL 8.0
%__subst "s|my_bool|bool|" net/common/ccnet-db.c

%build
%autoreconf
%configure --disable-static PYTHON=%__python3

# smp build does not work
%make_build || %make

%install
%makeinstall_std

%files
#_bindir/ccnet
#%_bindir/ccnet-tool

%files -n lib%name
%_libdir/*.so.*

%files -n python3-module-%name
%python3_sitelibdir/%name/

%files server
%_bindir/ccnet-init
%_bindir/%name-server
#_bindir/%name-servtool

%files -n lib%name-devel
%doc HACKING
%_includedir/ccnet/
%_includedir/ccnet.h
%_libdir/*.so
%_pkgconfigdir/lib%name.pc

%changelog
