%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}

%define rname cfitsio
%define sover 10
%define libname libcfitsio%sover
%define devame libcfitsio-devel

Name: cfitsio
Version: 4.6.2
Release: alt2
%define sversion %(echo %version | tr -d .)

Group: System/Libraries
License: BSD-like
Summary: Library for accessing files in FITS format for C and Fortran

Url: http://heasarc.gsfc.nasa.gov/docs/software/fitsio/

Source: %rname-%version.tar

BuildRequires: flex gcc-c++ gcc-fortran glibc-devel zlib-devel bzlib-devel
BuildRequires: chrpath

%description
CFITSIO is a library of C and Fortran subroutines for reading and
writing data files in FITS (Flexible Image Transport System) data format.
CFITSIO simplifies the task of writing software that deals with FITS
files by providing an easy to use set of high-level routines that insulate
the programmer from the internal complexities of the FITS file format.
At the same time, CFITSIO provides many advanced features that have made
it the most widely used FITS file programming interface in the astronomical
community.

%package -n %libname
License: BSD-like
Summary: Library for accessing files in FITS format for C and Fortran
Group: System/Libraries
%description -n %libname
CFITSIO is a library of C and Fortran subroutines for reading and
writing data files in FITS (Flexible Image Transport System) data
format.  CFITSIO simplifies the task of writing software that deals
with FITS files by providing an easy to use set of high-level routines
that insulate the programmer from the internal complexities of the
FITS file format.  At the same time, CFITSIO provides many advanced
features that have made it the most widely used FITS file programming
interface in the astronomical community.  This package contains the
shared library required by prgrams that use the cfits library.

%package -n %devame
License: BSD-like
Summary: Library for accessing files in FITS format for C and Fortran
Group: Development/C
Requires: %libname = %version-%release
Provides: fitsio-devel = %version-%release
Provides: %name-devel = %version-%release
%description -n %devame
  CFITSIO is a library of C and Fortran subroutines for reading and
writing data files in FITS (Flexible Image Transport System) data format.
CFITSIO simplifies the task of writing software that deals with FITS
files by providing an easy to use set of high-level routines that insulate
the programmer from the internal complexities of the FITS file format.
At the same time, CFITSIO provides many advanced features that have made
it the most widely used FITS file programming interface in the astronomical
community.
  This package contains the headers required for compiling software that uses
the cfits library.

%prep
%setup -n %rname-%version

%build
%configure --disable-static --enable-shared --enable-reentrant --with-bzip2
%make_build

%install
%makeinstall_std

chrpath -d %buildroot%_bindir/*

%files
%_bindir/f*

%files -n %libname
%_libdir/*.so.%sover
%_libdir/*.so.*

%files -n %devame
%_libdir/*.so
%_includedir/*
%_libdir/pkgconfig/*

%changelog
