%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: checkpolicy
Epoch: 1
Version: 3.8
Release: alt1
Summary: SELinux policy compiler
Group: System/Configuration/Other
License: GPLv2
Url: https://github.com/SELinuxProject/selinux

Source: %name-%version.tar

BuildRequires: flex
BuildRequires: libselinux-devel >= %version
BuildRequires: libsepol-devel >= %version
BuildRequires: libsepol-devel-static >= %version

%description
Security-enhanced Linux is a patch of the Linux(R) kernel and a number
of utilities with enhanced security functionality designed to add
mandatory access controls to Linux. The Security-enhanced Linux
kernel contains new architectural components originally developed to
improve the security of the Flask operating system. These
architectural components provide general support for the enforcement
of many kinds of mandatory access control policies, including those
based on the concepts of Type Enforcement(R), Role-based Access
Control, and Multi-level Security.

This package contains checkpolicy, the SELinux policy compiler.
Only required for building policies.

%prep
%setup

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%make_build LIBDIR=%_libdir CFLAGS="%optflags"

%install
%makeinstall_std LIBSEPOLA=%_libdir/libsepol.a
for f in dis{mod,pol}; do
	install test/$f %buildroot%_bindir/se$f
done

%find_lang --with-man --all-name %name

%files -f %name.lang
%_bindir/*
%_man8dir/*

%changelog
