%def_without test

Name: checksec
Version: 2.6.0
Release: alt1

Summary: Tool to check system for binary-hardening

License: BSD
Group: Development/Tools
Url: https://github.com/slimm609/%name.sh

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: %url/archive/%version.tar.gz#/%name-%version.tar

BuildArch: noarch

%if_with test
BuildRequires: binutils
BuildRequires: file
BuildRequires: findutils
BuildRequires: gawk
BuildRequires: libxml2
BuildRequires: openssl
BuildRequires: procps-ng
BuildRequires: %_bindir/jsonlint
%endif

%filter_from_requires /^.etc.lsb-release/d
%filter_from_requires /^.etc.os-release/d

#Requires: binutils
#Requires: file
#Requires: findutils
#Requires: gawk
#Requires: which

%description
Modern Linux distributions offer some mitigation techniques to make it harder
to exploit software vulnerabilities reliably. Mitigations such as RELRO,
NoExecute (NX), Stack Canaries, Address Space Layout Randomization (ASLR) and
Position Independent Executables (PIE) have made reliably exploiting any
vulnerabilities that do exist far more challenging. The checksec script is
designed to test what *standard* Linux OS and PaX (http://pax.grsecurity.net/)
security features are being used.

The script also lists the status of various Linux kernel protection mechanisms.

%name can check binary-files and running processes for hardening features.

%prep
%setup
# fix missed PATH under root: sysctl: command not found
%__subst 's|.*SHLVL.*||' checksec

# Disable --update command.
%__subst 's/pkg_release=false/pkg_release=true/' checksec

%build
# noop

%install
mkdir -p %buildroot%_bindir %buildroot%_man1dir
install -pm 0755 %name %buildroot%_bindir
install -pm 0644 extras/man/%name.1 %buildroot%_man1dir

%check
pushd tests
./xml-checks.sh || exit 2
./json-checks.sh || exit 2
popd

%files
%doc LICENSE.txt
%doc ChangeLog README.md
%_bindir/%name
%_man1dir/%name.1*

%changelog
