%define ver_major 6.4

Name: cinnamon-meta
Version: %ver_major.0
Release: alt2

Summary: Cinnamon desktop meta package
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME

Url: https://github.com/linuxmint/Cinnamon
BuildArch: noarch

%description
A set of virtual packages for Cinnamon Desktop installation.

%package -n cinnamon-default
Summary: A default Cinnamon desktop meta package
Group: Graphical desktop/GNOME

# cow@: cinnamon-minimal is now moved to cinnamon package.
# See https://bugzilla.altlinux.org/42722 for details
Requires: cinnamon-minimal >= %ver_major
Provides: cinnamon-full = %EVR
# Default terminal
Requires: gnome-terminal
# Default fonts for gnome-terminal >= 3.56.0 (GNOME 48)
Requires: fonts-ttf-adwaita

# Look and Feel
Requires: gnome-icon-theme
Requires: gnome-icon-theme-symbolic
Requires: gnome-themes-standard
Requires: libgtk2-engine-adwaita
Requires: gnome-backgrounds
# default font
Requires: fonts-otf-abattis-cantarell
# additional icons for cinnamon apps
Requires: xapps-icons

# Cinnamon uses yelp to show help
Requires: yelp

%description -n cinnamon-default
This package provides the various bits and pieces
for a default Cinnamon desktop.

%package -n cinnamon-regular
Summary: Meta package for Cinnamon desktop and set of default applications
Group: Graphical desktop/GNOME

Requires: cinnamon-default = %EVR

# Color manager
Requires: gnome-color-manager
# Password keeper
Requires: gnome-keyring
# Encryption keys management
Requires: seahorse
# Clipboard manager
Requires: parcellite
# Display manager
Requires: lightdm slick-greeter lightdm-settings
# Integration with fileroller (see #34711)
Requires: nemo-fileroller
# Support Samba files sharing
Requires: nemo-share

# Default Document viewer
Requires: xreader
# Default text editor
Requires: xed

# Utilities
Requires: gnome-utils
Requires: dconf-editor >= 0.10
Requires: gcalctool

# Default video player
Requires: celluloid
# Default image viewer
Requires: xviewer
# Default photo manager
Requires: pix

Requires: gnome-power-manager
Requires: NetworkManager-gnome >= 0.8.995
#Bluetooth configuration
#Requires: blueman

%description -n cinnamon-regular
This package provides Cinnamon desktop and set
of default applications.

%prep

%files -n cinnamon-default
%files -n cinnamon-regular

%changelog
