%define gst_api_ver 1.0

Name: clementine
Version: 1.4.1.32
Release: alt1.git2e6af22d7
Summary: A music player and library organiser

Group: Sound
License: %lgpl3only
Url: https://www.clementine-player.org/

Source0: %name-%version.tar.gz

BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): rpm-macros-cmake cmake
BuildRequires: boost-devel-headers gcc-c++
BuildRequires: libgio-devel libglew-devel libgpod-devel libmtp-devel
BuildRequires: libqt5-opengl libqt5-sql libqt5-webkit libqt5-xmlpatterns qt5-x11extras-devel
BuildRequires: libtag-devel
BuildRequires: gstreamer%{gst_api_ver}-devel gst-plugins%gst_api_ver-devel gstreamer%gst_api_ver-utils
BuildRequires: libchromaprint-devel
BuildRequires: libcryptopp-devel >= 6
# SQLITE_DBCONFIG_ENABLE_FTS3_TOKENIZER is available since 3.12
BuildRequires: libsqlite3-devel >= 3.12
BuildRequires: libpulseaudio-devel
BuildRequires: qt5-tools-devel
BuildRequires: libalsa-devel
BuildRequires: libfftw3-devel
BuildRequires: git

BuildRequires: protobuf-compiler
# Enable Google Drive support
BuildRequires: libgoogle-sparsehash
BuildRequires: libavcodec-devel libavformat-devel libpcre-devel
BuildRequires: libprotobuf-devel qjson-qt5-devel libcdio-devel

# Clementine crashes without it
Requires: gst-plugins-base%{gst_api_ver}
Requires: icon-theme-hicolor

%description
Clementine is a modern music player and library organizer

%add_python_req_skip clementine

%prep
%setup
%ifarch %e2k
%add_optflags -Winvalid-offsetof
sed -i "s|== Separator|== QChar(Separator)|" \
	ext/libclementine-tagreader/fmpsparser.cpp
%endif

if [ ! -d .git ]; then
    git init
    git config user.email author@example.com
    git config user.name author
    git add .
    git commit -m 'release'
    git tag -a '%version' -m '%version'
fi

%build
%cmake -DBUNDLE_PROJECTM_PRESETS=ON -DFORCE_GIT_REVISION=%version.%release
%cmake_build

%install
%cmakeinstall_std
%find_lang --with-kde %name

%files -f %name.lang
%doc Changelog
%_bindir/clementine
%_bindir/clementine-tagreader
%_desktopdir/org.clementine_player.Clementine.desktop
%_datadir/kservices5/*.protocol
%_datadir/clementine
%_datadir/metainfo/org.clementine_player.Clementine.appdata.xml
%_datadir/icons/hicolor/*/apps/*.png
%_datadir/icons/hicolor/*/apps/*.svg


%changelog
