# coccinelle.spec
%define _unpackaged_files_terminate_build 1
%set_verify_elf_method strict,unresolved=relaxed
%ifnarch armh
%define _stripped_files_terminate_build 1
%endif

Name:		coccinelle
Version: 1.3.0
Release: alt2
Summary:	Semantic patching for Linux (spatch)
Group:		Development/C
License:	GPL-2.0-only
Url:		http://coccinelle.lip6.fr/
Vcs:		https://github.com/coccinelle/coccinelle.git
Provides:	spatch
Requires:	python3-dev

Source:		%name-%version.tar
BuildRequires(pre): rpm-build-ocaml
BuildRequires(pre): rpm-build-python3
BuildRequires:	ocaml >= 3.12.1
BuildRequires:	ocaml-findlib
BuildRequires:	ocaml-menhir
BuildRequires:	ocaml-num-devel
BuildRequires:	ocaml-ocamldoc
BuildRequires:	ocaml-parmap-devel
BuildRequires:	ocaml-pcre-devel
BuildRequires:	ocaml-stdcompat-devel
BuildRequires:	python3-dev

# Bogus internal name
%filter_from_requires /^python.*(coccinelle)/d
# Bogus dependencies to OCaml
AutoReqProv: noocaml
# Only what's matter
Provides: ocaml-cmi(Coccilib) = %version-%release
Provides: ocaml-cmx(Coccilib) = %version-%release
# No cocciguis (pida for vim, gtk output), yet
%add_findreq_skiplist %python3_sitelibdir/coccilib/coccigui/*
# No trac integraion
%add_findreq_skiplist %python3_sitelibdir/coccilib/trac.py

%description
Coccinelle (French for "ladybug") is a utility for matching and
transforming the source code of programs written in the C programming
language.

The source code to be matched or replaced is specified using
a "semantic patch" syntax based on the patch syntax.
The Semantic Patch Language (SmPL) pattern resembles a unified diff
with C-like declarations.

Coccinelle was initially used to aid the evolution of the Linux kernel
(and ease the maintenance of device drivers), providing support for
changes to APIs such as renaming a function, adding a function
argument whose value is somehow context-dependent, and reorganizing a
data structure.

It can also be used to find bad programming patterns in code (i.e.,
pieces of code that are erroneous with high probability such as
possible NULL pointer dereference) without transforming them.
(Then coccinelle's role is close to that of static analysis tools.)

%package demos
%global demos_summary Demos of coccinelle semantic patches with C code examples
Summary: %demos_summary
Group: Documentation
Requires: %name = %EVR
BuildArch: noarch

%description demos
%demos_summary.

They can be applied to the corresponding C code examples by a command like:

  spatch -sp_file F.cocci F.c

and you'll get a normal patch for this C code example.

The tests from coccinelle are also included in this package; they can be run
with:

  spatch --testall --no-update-score-file

in the directory which includes the tests/ subdir (with *.res files).

%package checkinstall
%global checkinstall_summary Immediately run some tests for %name
Summary: %checkinstall_summary
Group: Development/Other
Requires: %name-demos = %EVR
BuildArch: noarch

%description checkinstall
%checkinstall_summary.

%prep
%setup
sed -i '1s|^#!.*python.*|#!%__python3|' tools/pycocci

# see https://bugzilla.altlinux.org/48475
find . -name Makefile | xargs sed -r  -i 's/-custom\s/-output-complete-exe /g'

%build
./autogen
%configure \
	--with-python=%__python3 \
	--disable-opt \
	%nil

make VERBOSE=yes

%install
%make DESTDIR=%buildroot install

# relocate python module
install -d %buildroot%python3_sitelibdir
mv %buildroot%_libdir/coccinelle/python/coccilib %buildroot%python3_sitelibdir/
rm -rf %buildroot%_libdir/coccinelle/python

# Somebody forgot to install this
install ./tools/pycocci %buildroot%_bindir/pycocci

%check
PATH=%buildroot%_bindir:$PATH
spatch --version
%define run_tests \
demos=( \
        simple # a simple demo \
        python_identifier # with embedded Python \
) \
for f in "${demos[@]}"; do \
        spatch -sp_file demos/"$f".{cocci,c} \
done

export COCCINELLE_HOME=%buildroot%_libdir/coccinelle
export PYTHONPATH=%buildroot%python3_sitelibdir
%run_tests

# tests/SCORE_expected.sexp should be generated with previous version
# of coccinelle by `spatch --testall`.
if yes | spatch -macro_file standard.h --iso-file standard.iso --testall > log 2>&1; then
	echo :: SCORE TEST SUCCESS
	tail log
else
	echo :: SCORE TEST FAILURE $?
	tail log
	exit 1
fi

%pre checkinstall -p %_sbindir/sh-safely
set -xe
cd %_docdir/%name-demos-%version
%run_tests

%files
%doc authors.txt bugs.txt changes.txt copyright.txt credits.txt
%doc license.txt readme.txt
%_bindir/pycocci
%_bindir/spatch
%_bindir/spgen
%_libdir/%name
%python3_sitelibdir/coccilib
%_man1dir/*.1*
%_man3dir/Coccilib.3cocci*
/usr/share/bash-completion/completions/spatch

%files demos
%doc demos tests

%files checkinstall

%changelog
