%global _unpackaged_files_terminate_build 1
%define _localstatedir %_var

# nftables or iptables
%define firewall_type iptables
#internal or systemd-resolved
%define dns_backend_type internal

Name: connman
Version: 1.42
Release: alt1

Summary: ConnMan is a daemon for managing internet connections.
License: GPL-2.0-only
Group: Networking/Other
Url: http://connman.net/

Source: %name-%version.tar
Source1: connmand.init
Source4: connman-openresolv.path
Source5: connman-openresolv.service

Patch: %name-%version.patch

BuildRequires: gcc-c++
BuildRequires: pkgconfig(glib-2.0) >= 2.40
BuildRequires: pkgconfig(dbus-1) >= 1.4
BuildRequires: openvpn vpnc xl2tpd pptp-client ppp-devel
BuildRequires: pkgconfig(openconnect) >= 8 openconnect
%if %firewall_type == iptables
BuildRequires: pkgconfig(xtables) >= 1.4.11
%else
BuildRequires: pkgconfig(libnftnl) >= 1.0.4
%endif
BuildRequires: pkgconfig(libmnl) >= 1.0.0
BuildRequires: pkgconfig(polkit-gobject-1)
BuildRequires: iptables
BuildRequires: wpa_supplicant
BuildRequires: gtk-doc libgnutls-devel libreadline-devel
BuildRequires: libselinux-devel
BuildRequires: systemd-devel libsystemd-devel

Provides: network-config-subsystem

%description
The Connection Manager (ConnMan) project provides a daemon for
managing internet connections within embedded devices running
the Linux operating system. ConnMan is designed to be slim
and to use as few resources as possible, so it can be easily integrated.
It is a fully modular system that can be extended, through plug-ins,
to support all kinds of wired or wireless technologies.
The plug-in approach allows for easy adaption and modification
for various use cases.

%package -n %name-docs
Summary: Documentation for %name
Group: Documentation
BuildArch: noarch

%description -n %name-docs
This package contains documentation files for %name

%package -n %name-devel
Summary: Include files for development with ConnMan Library
Group: Development/C
Requires: %name = %version-%release

%description -n %name-devel
The Connection Manager (ConnMan) project provides a daemon for managing
internet connections within embedded devices running the Linux operating system.

This package contains include files required for development %name-based software.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--enable-pie \
	--enable-debug \
	--with-systemdunitdir=%_unitdir \
	--with-tmpfilesdir=%_tmpfilesdir \
	--enable-datafiles \
	--enable-client \
	--enable-nmcompat \
	--enable-polkit \
	--enable-selinux \
	--enable-openconnect \
	--enable-openvpn \
	--enable-vpnc \
	--enable-l2tp \
	--enable-pptp \
	--enable-wireguard \
	--with-firewall=%firewall_type \
	--with-dns-backend=%dns_backend_type


%make_build runstatedir=/run

%install
%makeinstall_std

mkdir -p -- \
	%buildroot%_initdir \
	%buildroot%_sysconfdir/sysconfig \
	%buildroot%_localstatedir/lib/%name \
	%buildroot%_localstatedir/lib/%name-vpn \
#

echo 'CONNMAND_OPTS="-r"' > %buildroot%_sysconfdir/sysconfig/connman

install -pm0755 -D %SOURCE1          %buildroot%_initdir/connmand
install -pm0644 -D src/main.conf     %buildroot%_sysconfdir/connman/main.conf

ln -s connman.service %buildroot%_unitdir/connmand.service

find %buildroot%_libdir/%name -name '*.la' -delete

mkdir -p %buildroot%_unitdir/multi-user.target.wants
install -m644 %SOURCE4 %buildroot%_unitdir/connman-openresolv.path
install -m644 %SOURCE5 %buildroot%_unitdir/connman-openresolv.service
ln -s ../connman-openresolv.path %buildroot%_unitdir/multi-user.target.wants

%post
%post_service connmand

%preun
%preun_service connmand

%files
%_sbindir/*
%_bindir/*

%dir %_sysconfdir/connman
%config(noreplace) %_sysconfdir/connman/main.conf
%config(noreplace) %_sysconfdir/sysconfig/connman

%_datadir/dbus-1/system.d/*.conf
%_datadir/dbus-1/system-services/*.service

%_initdir/*
%_unitdir/*
%_tmpfilesdir/*

%dir %_libdir/%name
%dir %_libdir/%name/plugins*
%_libdir/%name/plugins*/*.so

%dir %_libdir/%name/scripts
%_libdir/%name/scripts/*.so
%_libdir/%name/scripts/*-script

%_datadir/polkit-1/actions/*

%_localstatedir/lib/%name
%_localstatedir/lib/%name-vpn

%_man1dir/*
%_man5dir/*
%_man8dir/*

%files -n %name-docs
%doc AUTHORS README TODO README ChangeLog doc/*.txt

%files -n %name-devel
%_pkgconfigdir/*.pc
%_includedir/*

%changelog
