%define libcontrolppver 0.32
%define confdir %{_sysconfdir}/%{name}
%define statedir %{_localstatedir}/%{name}
%define ulim_statedir %{statedir}/ulimits
%define perm_statedir %{statedir}/permissions
%define testsdir %{statedir}/tests

Name: control++
Version: 0.23.0
Release: alt1

Summary: System configuration tool
License: GPLv3
Group: System/Configuration/Other
Url: https://www.altlinux.org/Control++

Packager: Alexey Appolonov <alexey@altlinux.org>

# http://git.altlinux.org/people/alexey/packages/?p=controlplusplus.git
Source: %{name}-%{version}.tar

BuildRequires: gcc-c++
BuildRequires: rpm-build-python3
BuildRequires: libcontrol++-devel >= %{libcontrolppver}
BuildRequires: python3-module-ax

Requires: libcontrol++

%description
%{name} is a simple system configuration tool that allows administrator
to change system ulimits, set permission modes and, in perspective,
perform other administrative operations.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{name}-wl
Summary: Files that can help to configure whitelist permission mode
Group: System/Configuration/Other

Requires(pre): %{name}

%description -n %{name}-wl
Files that can help to configure whitelist permission mode:
1) A sample of a permission mode with an extensive real-life 'whitelist'
section;
2) A shell script that can generate a list of all executable files of the host
system (to be used with the sample described above).

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%package -n %{name}-checkinstall
Summary: Tests and test data for %{name}
Group: Other

Requires(pre): %{name}
Requires(pre): %{name}-wl
Requires: python3
Requires: python3-module-ax >= 0.17

%description -n %{name}-checkinstall
Tests and test data for %{name}.

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%prep
%setup

%build
%make_build

%check
%{buildroot}%{testsdir}/run --targets all --mode check

%install
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_defaultdocdir}/%{name}
mkdir -p %{buildroot}%{confdir}
mkdir -p %{buildroot}%{ulim_statedir}
mkdir -p %{buildroot}%{perm_statedir}
mkdir -p %{buildroot}%{testsdir}
mkdir -p %{buildroot}/run/%{name}
# Executables
cp bin/%{name} %{buildroot}%{_bindir}
# Configuration
cp -r samples/* %{buildroot}%{confdir}
# Documentation
cp COPYING %{buildroot}%{_defaultdocdir}/%{name}
cp usage.txt %{buildroot}%{_defaultdocdir}/%{name}
cp readme.txt %{buildroot}%{_defaultdocdir}/%{name}
# Tests
cp -r tests/* %{buildroot}%{testsdir}

%post -n %{name}-checkinstall
%{testsdir}/run --targets all --mode checkinstall

%files
%{_bindir}/%{name}
%{confdir}
%exclude %{confdir}/wl.sh
%exclude %{confdir}/permissions/wl
%exclude %{confdir}/excluded_from_white_list
%config(noreplace) %{confdir}/%{name}.conf
%dir %{statedir}
%dir %{ulim_statedir}
%dir %{perm_statedir}
%{_defaultdocdir}/%{name}

%files -n %{name}-wl
%{confdir}/wl.sh
%{confdir}/permissions/wl
%{confdir}/excluded_from_white_list

%files -n %{name}-checkinstall
%{testsdir}/*
%dir /run/%{name}

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

%changelog
