%def_without check

Summary: Twm based window manager for the X Window System
Summary(ru): Основанный на twm оконный менеджер для X Window System
Name: ctwm
Version: 4.1.0
Epoch: 1
Release: alt1

Source: %name-%version.tar.xz
Url: http://www.ctwm.org/index.html

Source1: startctwm
Source2: %name.wmsession
Source3: %name.icon64x64.xpm
Source4: %name.desktop
Source5: %name-systemd.desktop
Source6: %name-session-target
Source7: %name.service
Source8: %name-session.target
Source9: %name.target

Patch: ctwm-3.8.2-GetFont.patch
License: BSD
Group: Graphical desktop/Other

# Automatically added by buildreq on Wed Jun 29 2022
# optimized out: asciidoc cmake-modules docbook-dtds docbook-style-xsl glibc-kernheaders-generic glibc-kernheaders-x86 libICE-devel libSM-devel libX11-devel libXau-devel libXrender-devel libXt-devel libcrypt-devel libgpg-error libsasl2-3 libxcb-devel python3 python3-base sh4 xml-common xml-utils xorg-proto-devel xsltproc xz
BuildRequires: asciidoc-a2x cmake ctags doxygen flex graphviz libXext-devel libXmu-devel libXpm-devel libXrandr-devel libjpeg-devel

%description
Ctwm is a window manager for the X Window System.  It provides
titlebars, shaped windows, virtual screens (workspaces), several forms
of icon management, user-defined macro functions, click-to-type and
pointer-driven keyboard focus, and user-specified key and pointer
button bindings.  It is actually twm (Tab Window Manager) from the MIT
X11 distribution slightly modified to accommodate the use of several
virtual screens (workspaces). It is heavily inspired from the
Hewlett-Packard vuewm window manager.  In addition, ctwm can use
coloured, shaped icons and background root pixmaps in XPM format [from
Arnaud Le Hors], any format understood by the imconv package [from the
San Diego Supercomputer Center] and xwd files.  Ctwm can be compiled
to use both, either or none of the above icon/pixmap formats.

%description -l ru
Ctwm -- оконный менеждер для X Windows System, основанный на одном из
старейших  оконных менеджеров для X11 -- twm (Tab Window Manager) из
дистрибутива Mit X11. Под влиянием vuewm от Hewlett-Packard в ctwm
добавлена поддержка "трёхмерных" заголовков, рамоки меню, виртуальные
экраны и многое другое. Ctwm поддерживает макросы в настройках,
разнообразные стили перемещения фокуса, заливку фона и т. д., а также
имеет несколько уникальных функций, например movepush, когда окно,
перемещаемое по экрану, расталкивает прочие окна в стороны.

%package docs
BuildArch: noarch
Summary: Developmeatn documentation for %name
Group: Graphical desktop/Other
%description docs
%summary

%package systemd
BuildArch: noarch
Summary: Systemd services ans scripts for %name
Group: Graphical desktop/Other
Requires: %name = %version-%release
%description systemd
%summary

%prep
%setup
#patch -p1
sed -ri 's/(#define[[:space:]]+MAX_BUTTONS[[:space:]]+).*/\1 24/' ctwm.h
%cmake \
    -DETCDIR=%_sysconfdir/X11/ctwm \
    -DDOCDIR=%_defaultdocdir/%name-%version \
    -DEXAMPLEDIR=%_defaultdocdir/%name-%version \
    -DMANUAL_BUILD_HTML=True -DENABLE_ASCIIDOC_HTML=True
    # unmaintained -DDO_CLIENT=ON

%build
%cmake_build -t all -t doxygen
(cd doc/devman; for N in *adoc; do asciidoc -atoc -anumbered $N; done)

%install
%cmakeinstall_std
install -d %buildroot%_datadir/xsessions
install %SOURCE4 %buildroot%_datadir/xsessions/
install %SOURCE5 %buildroot%_datadir/xsessions/
install -D %SOURCE3 %buildroot/%_iconsdir/hicolor/64x64/apps/%name.xpm
install -D %SOURCE1 %buildroot/%_sysconfdir/X11/wmsession.d/07%name
install -D system.ctwmrc %buildroot/%_sysconfdir/X11/%name/system.ctwmrc
install -D %SOURCE1 %buildroot/%_bindir/startctwm
install -D %SOURCE6 %buildroot%prefix/libexec/%name-session-target
install -d %buildroot%_user_unitdir
install -D %SOURCE7 %buildroot%_user_unitdir/
install -D %SOURCE8 %buildroot%_user_unitdir/
install -D %SOURCE9 %buildroot%_user_unitdir/
install -D %_cmake__builddir/ctwm.1 %buildroot%_man1dir/ctwm.1

%files
%doc %_defaultdocdir/%name-%version
%_iconsdir/hicolor/64x64/apps/*
%_bindir/*
%_mandir/man1/*
%config(noreplace) %_sysconfdir/X11/%name/system.ctwmrc
%_sysconfdir/X11/wmsession.d/*
%_datadir/%name/
%_datadir/xsessions/%name.desktop

%files docs
%doc %_cmake__builddir/doxygen/html
%doc doc/devman/*.html doc/devman/static

%files systemd
%_user_unitdir/*
%prefix/libexec/*
%_datadir/xsessions/%name-systemd.desktop

%if_with check
%check
%cmake_build -t test
%endif

%changelog
