%def_disable static

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%global optflags_lto %optflags_lto -ffat-lto-objects

ExcludeArch: ppc64le

Summary: A free SOCKS v4/v5 client implementation
Name: dante
Version: 1.4.4
Release: alt1
License: BSD-type
Group: Security/Networking
Url: http://www.inet.no/dante/

Source: ftp://ftp.inet.no/pub/socks/%name-%version.tar.gz
Source1: sockd.init
Source2: pam_userdb.passwd
Source3: sockd.conf
Source4: sockd.sysconfig
Source5: sockd.pam
Source6: pam_userdb.passwd.1
Patch0:	dante-am.patch
Patch1:	dante-build.patch
Patch2:	dante-cpp.patch
Patch3: dante-getaddrinfo_check_drop.patch
Patch4: dante-1.4.4-alt-SIOCGIFHWADDR.patch

BuildRequires(pre): rpm-macros-systemd
BuildRequires: db4.7-utils
BuildRequires: flex
BuildRequires: libkrb5-devel
BuildRequires: libldap-devel
BuildRequires: libpam0-devel
BuildRequires: libsasl2-devel

%description
Dante is a free implementation of the SOCKS proxy protocol, version 4,
and version 5 (rfc1928). It can be used as a firewall between
networks. It is being developed by Inferno Nettverk A/S, a Norwegian
consulting company. Commercial support is available.

This package contains the dynamic libraries required to "socksify"
existing applications, allowing them to automatically use the SOCKS
protocol.

%package server
Summary: A free SOCKS v4/v5 server implementation
Group: Security/Networking
Requires: dante

%description server
This package contains "sockd", the SOCKS proxy daemon and its
documentation.  This is the server part of the Dante SOCKS proxy
package and allows SOCKS clients to connect through it to the external
network.

%package devel
Summary: development libraries for SOCKS
Group: Development/C
Requires: dante = %EVR

%description devel
Static libraries required to compile programs including SOCKS.

%package devel-static
Summary: development libraries for SOCKS
Group: Development/C
Requires: lib%name-devel = %EVR

%description devel-static
Static libraries required to compile programs including SOCKS.

%prep
%setup
%autopatch -p1

%build
%autoreconf
PATH=:$PATH:/sbin # /sbin is required to run ldconfig to find libc for preload support.
%configure \
	--disable-silent-rules \
	--without-glibc-secure \
	--without-upnp \
	--enable-clientdl \
	--enable-serverdl \
	--enable-preload \
	--enable-shared \
	%{subst_enable static} \
	%nil
%make_build
%SOURCE2 -e -f passwd.db

%install
%makeinstall

install -D -m 0644 example/socks-simple.conf $RPM_BUILD_ROOT/%_sysconfdir/socks.conf
install -D -m 0755 %SOURCE1 $RPM_BUILD_ROOT/%_initdir/sockd
install -m755 %SOURCE2 $RPM_BUILD_ROOT/%_bindir/sockd.passwd
install -D %SOURCE6 $RPM_BUILD_ROOT/%_man1dir/sockd.passwd.1
install -m 0644 %SOURCE3 $RPM_BUILD_ROOT/%_sysconfdir/sockd.conf
install -D -m 0644 %SOURCE4 $RPM_BUILD_ROOT/%_sysconfdir/sysconfig/sockd
install -D -m 0644 %SOURCE5 $RPM_BUILD_ROOT/%_sysconfdir/pam.d/sockd
install -D passwd.db $RPM_BUILD_ROOT/%_sharedstatedir/sockd/passwd.db
install -D -m 0644 SPECS/dante.service $RPM_BUILD_ROOT/%_unitdir/%name.service
# make repocop happy - comply with The Policy!
# https://www.altlinux.org/Services_Policy#systemd
pushd $RPM_BUILD_ROOT/%_unitdir/
ln -s  %name.service sockd.service
popd


%pre server
useradd -r -c "SOCKS server" -d /var/empty -s /dev/null _sockd || :

%post server
test -r %_sharedstatedir/sockd/passwd.db || sockd.passwd -r
%systemd_post sockd.service

%preun server
%systemd_preun sockd.service

%postun server
%systemd_postun sockd.service

%files
%doc BUGS CREDITS LICENSE NEWS README* SUPPORT doc/README* example/*.conf
%config %_sysconfdir/socks.conf
%_libdir/libsocks.so.0.*
%_libdir/libsocks.so.0
%_libdir/libdsocks.so
%_bindir/socksify
%_man1dir/socksify.1*
%_man5dir/socks.conf.5*

%files server
%config %_sysconfdir/sockd.conf
%config %_sysconfdir/sysconfig/sockd
%dir %_sharedstatedir/sockd
%config(noreplace) %_sharedstatedir/sockd/passwd.db
%_initdir/sockd
%config(noreplace) %_sysconfdir/pam.d/sockd
%_sbindir/sockd
%_bindir/sockd.passwd
%_man5dir/sockd*
%_man8dir/sockd*
%_man1dir/sockd*
%_unitdir/*.service

%files devel
%doc INSTALL doc/rfc* doc/*.protocol
%_libdir/libsocks.so
%_includedir/socks.h

%if_enabled static
%files devel-static
%_libdir/libsocks.a
%endif

%changelog
