Name: dar
Version: 2.7.13
Release: alt1

Summary: Disk ARchive tool

License: GPLv2+
Group: File tools
Url: http://dar.linux.free.fr/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://prdownloads.sf.net/%name/%name-%version.tar

BuildRequires: doxygen gcc-c++
BuildRequires: libattr-devel libcap-devel libe2fs-devel libgcrypt-devel libgpgme-devel libcurl-devel librsync-devel
BuildRequires: bzlib-devel liblzma-devel liblzo2-devel zlib-devel liblz4-devel libzstd-devel
BuildRequires: libargon2-devel
BuildRequires: perl-devel groff-base man

Requires: lib%name = %EVR

%description
dar is a shell command, that makes backup of a directory tree and files.
It has been tested under Linux, Windows (95, 2000, NT, XP), Solaris 8,
FreeBSD and NetBSD, it has been reported as working under Mac OS X 10.3.

%package -n lib%name
Summary: Library for %name
Group: Development/C

%description -n lib%name
This package contains library for %name.

%package -n lib%name-devel
Summary: Devel files for lib%name
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
This package contains header files for %name.

%package doc
Summary: Documentation files for %name
Group: File tools
BuildArch: noarch

%description doc
This package contains documentation files for %name.

%prep
%setup
sed -i "s@\(O_WRONLY|O_CREAT|O_TRUNC|O_BINARY\)@\1, 0666@" src/testing/test_generic_file.cpp
# for autopoint
sed -i "s|AM_GNU_GETTEXT_VERSION|AM_GNU_GETTEXT_VERSION(0.18.2)|g" configure.ac

cat >>src/libdar/Makefile.am <<EOF
libdar64_la_LIBADD = -lcurl -lgpgme
libdar32_la_LIBADD = -lcurl -lgpgme
libdar_la_LIBADD = -lcurl -lgpgme
EOF

%autoreconf

%build
#autoreconf #for disable rpath
%configure --disable-static --disable-upx \
           --disable-rpath \
           --enable-curl-linking --enable-gpgme-linking
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%ifarch %e2k
# src/check/.libs/lt-bnonzero: error while loading shared libraries:
# libdar64.so.6000: cannot open shared object file: No such file or directory
export LD_LIBRARY_PATH+=`pwd`/src/libdar/.libs
%endif
%make_build

%install
%makeinstall_std pkgdatadir=%_docdir/%name-%version
%find_lang %name

%files -f %name.lang
%config(noreplace) %_sysconfdir/darrc
%_bindir/*
%_man1dir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%files doc
%_docdir/%name-%version/

%changelog
