%define _libexecdir %_prefix/lib/dbus-1

%define dbus_user      messagebus
%define dbus_group     messagebus

%define system_socket_dir /run/dbus
%define session_socket_dir %system_socket_dir/users
%define system_socket %system_socket_dir/system_bus_socket
%define	systemdsystemunitdir %_prefix/lib/systemd/system
%define systemdsessionunitdir %_prefix/lib/systemd/user

Name: dbus
Version: 1.16.0
Release: alt2

Summary: D-BUS is a simple IPC framework based on messages.
License: AFL/GPL
Group: System/Servers
Url: http://www.freedesktop.org/Software/dbus

Packager: Valery Inozemtsev <shrek@altlinux.ru>

PreReq: shadow-utils
Requires: lib%name = %version-%release
Provides: /bin/dbus-run-session /bin/dbus-send

BuildRequires: doxygen gcc-c++ libexpat-devel libSM-devel libX11-devel xmlto libselinux-devel libaudit-devel libcap-ng-devel
BuildRequires: libsystemd-daemon-devel libsystemd-login-devel libsystemd-journal-devel meson

Source: %name-%version.tar
Patch: %name-%version.patch

%description
D-BUS is a system for low-latency, low-overhead, easy to use interprocess
communication (IPC). In more detail:

  o D-BUS is low-latency because it is designed to avoid round trips and
    allow asynchronous operation, much like the X protocol.

  o D-BUS is low-overhead because it uses a binary protocol, and does not
    have to convert to and from a text format such as XML. Because D-BUS is
    intended for potentially high-resolution same-machine IPC, not primarily
    for Internet IPC, this is an interesting optimization.

  o D-BUS is easy to use because it works in terms of messages rather than
    byte streams, and automatically handles a lot of the hard IPC issues.
    Also, the D-BUS library is designed to be wrapped in a way that lets
    developers use their framework's existing object/type system, rather
    than learning a new one specifically for IPC.

This package contains D-BUS daemon and system utilities.

%package tools
Summary: D-BUS user helper tools
Group: Monitoring
Requires: %name = %version-%release
Provides: dbus-userhelpers = %version-%release
Obsoletes: dbus-userhelpers

%description tools
This package includes user tools for launching D-BUS service on session startup

%package tools-gui
Summary:  D-BUS user helper tools
Group: Monitoring
Requires: %name = %version-%release

%description tools-gui
This package includes user tools for launching D-BUS service on session startup

%package -n lib%name
Summary: D-BUS shared libraries
Group: System/Libraries

%description -n lib%name
This package contains D-BUS shared libraries

%package -n lib%name-devel
Summary: D-BUS development files
Group: Development/C
Requires: lib%name = %version-%release
%description -n lib%name-devel
This package contains D-BUS development files (headers and libraries links)

%add_findreq_skiplist %_x11sysconfdir/xinit.d/*

%prep
%setup -q
%patch -p1

%build
%meson \
	-Dasserts=false \
	-Dxml_docs=enabled \
	-Ddoxygen_docs=enabled \
	-Dinotify=enabled \
	-Dlibaudit=enabled \
	-Dselinux=enabled \
	-Dsystemd=enabled \
	-Duser_session=true \
	-Dsystem_pid_file=/run/messagebus.pid \
	-Dsystem_socket=%system_socket \
	-Dsession_socket_dir=%session_socket_dir \
	-Dsystemd_system_unitdir=%systemdsystemunitdir

%meson_build -v

%install
%meson_install

ln -sf dbus.service %buildroot/%systemdsystemunitdir/messagebus.service

install -pD -m0755 bus/messagebus.in %buildroot%_initdir/messagebus

mkdir -p %buildroot%_sysconfdir/dbus-1/system.d
mkdir -p %buildroot%_sysconfdir/dbus-1/session.d
mkdir -p %buildroot%_datadir/dbus-1/interfaces
mkdir -p %buildroot%system_socket_dir
mkdir -p %buildroot%session_socket_dir
mkdir -p %buildroot%_localstatedir/dbus
touch %buildroot%_localstatedir/dbus/machine-id
touch %buildroot%_sysconfdir/machine-id

mkdir -p %buildroot/run/dbus/users

mkdir -p %buildroot%_tmpfilesdir
cat << __EOF__ > %buildroot%_tmpfilesdir/%name.conf
d /run/dbus 0755 root root -
d /run/dbus/users 1777 root root -
__EOF__

%pre
%_sbindir/groupadd -r -f %dbus_group 2> /dev/null ||:
%_sbindir/useradd -r -n -g %dbus_group -d %system_socket_dir -s /dev/null -c "D-Bus System User" %dbus_user 2> /dev/null ||:

%post
if [ $1 -eq 1 ] ; then
	/sbin/chkconfig --add messagebus
else
	/sbin/chkconfig messagebus resetpriorities
fi
%_bindir/dbus-uuidgen --ensure

%preun
%preun_service messagebus

%files
%dir %_sysconfdir/dbus-1
%config(noreplace) %_sysconfdir/dbus-1/*.conf
%dir %_sysconfdir/dbus-1/system.d
%dir %_sysconfdir/dbus-1/session.d
%ghost %_sysconfdir/machine-id
%_initdir/messagebus
%systemdsystemunitdir/*
%systemdsessionunitdir/*
%_tmpfilesdir/%name.conf
%_prefix/lib/sysusers.d/%name.conf
%_bindir/dbus-cleanup-sockets
%_bindir/dbus-daemon
%_bindir/dbus-uuidgen
%_bindir/dbus-run-session
%_bindir/dbus-update-activation-environment
%dir %_prefix/lib/dbus-1
%attr(4510,root,messagebus) %_prefix/lib/dbus-1/dbus-daemon-launch-helper
%dir %_datadir/dbus-1
%dir %_datadir/dbus-1/interfaces
%dir %_datadir/dbus-1/system.d
%dir %_datadir/dbus-1/session.d
%dir %_datadir/dbus-1/services
%dir %_datadir/dbus-1/system-services
%_datadir/dbus-1/session.conf
%_datadir/dbus-1/system.conf
%dir %_localstatedir/dbus
%ghost %_localstatedir/dbus/machine-id
%_man1dir/dbus-cleanup-sockets.1*
%_man1dir/dbus-daemon.1*
%_man1dir/dbus-uuidgen.1*
%_man1dir/dbus-run-session.1*
%_man1dir/dbus-update-activation-environment.1*

%dir %attr(0755,root,root) /run/dbus
%dir %attr(1777,root,root) /run/dbus/users

%files tools
%_bindir/dbus-monitor
%_bindir/dbus-send
%_man1dir/dbus-send.1*
%_man1dir/dbus-monitor.1*

%files tools-gui
%attr(0755,root,root) %_sysconfdir/X11/xinit.d/00-start-message-bus.sh
%_bindir/dbus-launch
%_man1dir/dbus-launch.1*

%files -n lib%name
%_libdir/libdbus-1.so.*

%files -n lib%name-devel
%_bindir/dbus-test-tool
%_datadir/doc/%name
%_includedir/dbus-1.*
%_libdir/libdbus-1.so
%_libdir/dbus-1.*
%_libdir/cmake/DBus1
%_pkgconfigdir/dbus-1.pc
%dir %_datadir/dbus-1
%dir %_datadir/dbus-1/interfaces
%_datadir/xml/dbus-1
%_man1dir/dbus-test-tool.1*

%changelog
