%define _unpackaged_files_terminate_build 1

%define rhelp_version 0.3.0
# plugins 
%add_verify_elf_skiplist %_libdir/*.so

Name:           dd_rescue
Version:        1.99.20
Release:        alt1
Summary:        Fault tolerant "dd" utility for rescuing data from bad media
Group:          File tools
License:        GPLv2
URL:            https://www.garloff.de/kurt/linux/ddrescue/
VCS:            https://git.code.sf.net/p/ddrescue/code
Source:         %name-%version.tar
# http://www.kalysto.org/pkg/dd_rhelp-%{rhelp_version}.tar.gz
Source1:        dd_rhelp-%{rhelp_version}.tar

Patch1: dd_rescue-%version-alt.patch

BuildRequires: autoconf
BuildRequires: libacl-devel libattr-devel

%description
ddrescue is a utility similar to the system utility "dd" which copies
data from a file or block device to another. ddrescue does however
not abort on errors in the input file. This makes it suitable for
rescuing data from media with errors, e.g. a disk with bad sectors.

This package includes dd_rhelp, a wrapper script facilitating data 
recovery.

%prep
%setup
%setup -a 1 -D -T
%patch1 -p1
%ifarch %e2k
# The combination of the laziness of the author of the makefile and
# the desire of the compiler for Elbrus to throw errors for any reason
# leads to an error, since the makefile tries to build dependencies
# for every source file, including those that don't have the required
# includes and will not compile.
sed -i 's/$(CC) $(CFLAGS) -DGEN_DEP/echo >.dep #/' Makefile
%endif

%build
%make RPM_OPT_FLAGS="%{optflags}" %{?_smp_mflags} LIB=%_lib LIBDIR=%{_libdir}
cp -p README.dd_rescue README
cp -p dd_rhelp-%{rhelp_version}/README README.dd_rhelp
cp -p dd_rhelp-%{rhelp_version}/FAQ FAQ.dd_rhelp

%install
%makeinstall_std INSTALLDIR=%{buildroot}/%{_bindir} INSTASROOT="" INSTALLFLAGS="" LIB=%_lib LIBDIR=%{_libdir}
install -D -m 755 dd_rhelp-%{rhelp_version}/dd_rhelp %{buildroot}%{_bindir}/dd_rhelp

%files
%doc COPYING README README.dd_rhelp FAQ.dd_rhelp
%_bindir/dd_rescue
%_bindir/dd_rhelp
%_libdir/libddr_MD5.so
%_libdir/libddr_crypt.so
%_libdir/libddr_hash.so
%_libdir/libddr_null.so
%_man1dir/%{name}.*
%_man1dir/ddr_crypt.1*
%_man1dir/ddr_lzo.1*
%_man1dir/ddr_lzma.1*

%changelog
