%define repo dde-file-manager
%define soname 1

%def_without clang

Name: deepin-file-manager
Version: 6.0.50
Release: alt1

Summary: Deepin File Manager

License: GPL-3.0-or-later
Group: File tools
Url: https://github.com/linuxdeepin/dde-file-manager

Packager: Leontiy Volodin <lvol@altlinux.org>

Source: %url/archive/%version/%repo-%version.tar.gz
Patch0: deepin-file-manager-6.0.50-alt-fix-paths.patch

Provides: %repo = %EVR

BuildRequires(pre): rpm-build-ninja rpm-macros-dqt5
# Automatically added by buildreq on Thu Oct 26 2023
# optimized out: alt-os-release bash5 bashrc boost-asio-devel boost-devel-headers boost-filesystem-devel cmake cmake-modules gcc-c++ glib2-devel glibc-kernheaders-generic glibc-kernheaders-x86 gsettings-qt-devel icu-utils libX11-devel libdeepin-pdfium1 libdfm-burn1 libdfm-io1 libdfm-mount1 libdouble-conversion3 libdtkcore-devel libdtkgui-devel libdtkwidget-devel libffmpegthumbnailer-devel libgio-devel libglvnd-devel libgpg-error libgsettings-qt libicu-devel libisoburn-devel libp11-kit libpolkit-dqt5-agent libpolkit-qt5-core libpolkit-qt5-gui libpoppler0-cpp libdqt5-concurrent libdqt5-core libdqt5-dbus libdqt5-gui libdqt5-multimedia libdqt5-network libdqt5-printsupport libdqt5-sql libdqt5-svg libdqt5-widgets libdqt5-x11extras libdqt5-xml libsasl2-3 libsecret-devel libssl-devel libstartup-notification libstdc++-devel libudisks2-devel libxcb-devel pkg-config python3 python3-base python3-dev python3-module-setuptools dqt5-base-common dqt5-base-devel dqt5-x11extras-devel sh5 xorg-proto-devel zlib-devel
BuildRequires: cmake deepin-dock-devel deepin-qt-dbus-factory-devel dtk6-common-devel dtkcore kf5-kcodecs-devel libcryptsetup-devel libdeepin-pdfium-devel libdfm-burn-devel libdfm-io-devel libdfm-mount-devel libdmr-devel libdocparser-devel liblucene++-devel libmount-devel libpcre-devel libpolkit-devel libpolkitqt5-qt5-devel libpoppler-cpp-devel libtag-devel dqt5-multimedia-devel dqt5-svg-devel dqt5-tools dqt5-x11extras-devel gsettings-qt-devel libffmpegthumbnailer-devel
BuildRequires: deepin-gettext-tools deepin-desktop-base

%if_with clang
BuildRequires: clang-devel lld-devel libstdc++-devel
%else
BuildRequires: gcc-c++
%endif

Requires: libdqt5-gui = %_dqt5_version libdqt5-widgets = %_dqt5_version

%description
File manager front end of Deepin OS.

%package -n lib%repo%soname
Summary: Library for %name
Group: System/Libraries

%description -n lib%repo%soname
Library for %name.

%package -n lib%repo-devel
Summary: Development files for %name
Group: Development/Other

%description -n lib%repo-devel
Development files for %name.

%package -n libdfm-extension%soname
Summary: Library for %name extensions
Group: System/Libraries

%description -n libdfm-extension%soname
Library for %name extensions.

%package -n libdfm-extension-devel
Summary: Development files for %name extensions
Group: Development/Other

%description -n libdfm-extension-devel
Development files for %name extensions.

%package -n libdfm-base%soname
Summary: Library for %name extensions
Group: System/Libraries

%description -n libdfm-base%soname
Library for %name extensions.

%package -n libdfm-base-devel
Summary: Development files for %name extensions
Group: Development/Other

%description -n libdfm-base-devel
Development files for %name extensions.

%package -n libdfm-framework%soname
Summary: Library for %name extensions
Group: System/Libraries

%description -n libdfm-framework%soname
Library for %name extensions.

%package -n libdfm-framework-devel
Summary: Development files for %name extensions
Group: Development/Other

%description -n libdfm-framework-devel
Development files for %name extensions.

%package -n deepin-desktop
Summary: Deepin desktop environment - desktop module
Group: Graphical desktop/Other

%description -n deepin-desktop
Deepin desktop environment - desktop module.

%prep
%setup -n %repo-%version
%autopatch -p1

%build
%define optflags_lto %nil
%if_with clang
export CC=clang
export CXX=clang++
export LDFLAGS="-fuse-ld=lld $LDFLAGS"
%else
export CC=gcc
export CXX=g++
%endif
export CMAKE_PREFIX_PATH=%_dqt5_libdir/cmake:$CMAKE_PREFIX_PATH
export PKG_CONFIG_PATH=%_dqt5_libdir/pkgconfig:$PKG_CONFIG_PATH
export CPLUS_INCLUDE_PATH=%_includedir/qt5:$CPLUS_INCLUDE_PATH
export PATH=%_dqt5_bindir:$PATH
%cmake \
    -GNinja \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DCMAKE_SKIP_INSTALL_RPATH:BOOL=no \
    -DCMAKE_INSTALL_RPATH=%_dqt5_libdir \
    -DCMAKE_INSTALL_PREFIX=%_prefix \
    -DCMAKE_INSTALL_SYSCONFDIR=%_sysconfdir \
    -DSYSTEMD_USER_UNIT_DIR=%_userunitdir \
    -DVERSION=%version \
    -DLIB_INSTALL_DIR=%_lib \
    -DDFM_PLUGIN_DIR=%_libdir/%repo/plugins \
#
cmake --build "%_cmake__builddir" -j%__nprocs

%install
%cmake_install
chmod +x %buildroot%_sysconfdir/deepin/dde-file-manager/dfm-dlnfs-automount
chmod +x %buildroot%_bindir/%repo-pkexec
chmod +x %buildroot%_bindir/dde-property-dialog

%files
%doc README.md LICENSE
%_bindir/%repo
%_bindir/%repo-daemon
%_bindir/%repo-pkexec
%_bindir/%repo-server
%_bindir/dde-property-dialog
%_bindir/dde-select-dialog-x11
%_bindir/dde-select-dialog-wayland
%_bindir/dde-file-dialog
%_bindir/dfm-open.sh
%_datadir/%repo/
%_desktopdir/%repo.desktop
%_sysconfdir/X11/Xsession.d/99dfm-dlnfs-automount
%dir %_sysconfdir/deepin/
%dir %_sysconfdir/deepin/dde-file-manager/
%_sysconfdir/deepin/dde-file-manager/dfm-dlnfs-automount
%_datadir/dbus-1/interfaces/com.deepin.filemanager.filedialog.xml
%_datadir/dbus-1/interfaces/com.deepin.filemanager.filedialogmanager.xml
%_datadir/glib-2.0/schemas/com.deepin.dde.dock.module.disk-mount.gschema.xml
%_datadir/glib-2.0/schemas/com.deepin.dde.filemanager.gschema.xml
%_datadir/dbus-1/services/com.deepin.filemanager.filedialog.service
%_datadir/dbus-1/services/org.freedesktop.FileManager.service
%_datadir/dbus-1/system-services/com.deepin.filemanager.daemon.service
%_sysconfdir/dbus-1/system.d/com.deepin.filemanager.daemon.conf
%_unitdir/dde-filemanager-daemon.service
%_userunitdir/dde-file-manager.service
%dir %_userunitdir/dde-session-initialized.target.wants/
%_userunitdir/dde-session-initialized.target.wants/dde-file-manager.service
%_datadir/dbus-1/services/com.deepin.filemanager.filedialog_x11.service
%_datadir/dbus-1/services/com.deepin.filemanager.filedialog_wayland.service
%_datadir/dbus-1/services/org.deepin.filemanager.server.service
%dir %_datadir/deepin/
%_datadir/deepin/%repo/
%_datadir/mime/packages/dtk-dci.xml
%_datadir/polkit-1/actions/com.deepin.pkexec.dde-file-manager.policy
%_datadir/polkit-1/actions/com.deepin.filemanager.daemon.accesscontrol.policy
%_datadir/polkit-1/actions/com.deepin.filemanager.daemon.sharecontrol.policy
%_datadir/polkit-1/actions/com.deepin.filemanager.vault.policy
%_datadir/applications/context-menus/.readme
%dir %_datadir/dsg/
%dir %_datadir/dsg/configs/
%dir %_datadir/dsg/configs/org.deepin.dde.file-manager/
%_datadir/dsg/configs/org.deepin.dde.file-manager/*.json
%dir %_libdir/dde-dock/
%dir %_libdir/dde-dock/plugins/
%dir %_libdir/dde-dock/plugins/system-trays/
%_libdir/dde-dock/plugins/system-trays/libdde-disk-mount-plugin.so
%dir %_libdir/%repo/
%dir %_libdir/%repo/tools/
%_libdir/%repo/tools/libdfm-upgrade.so
%_libdir/%repo/plugins/
%dir %_datadir/deepin-manual/
%dir %_datadir/deepin-manual/manual-assets/
%dir %_datadir/deepin-manual/manual-assets/application/
%dir %_datadir/deepin-manual/manual-assets/application/%repo/
%_datadir/deepin-manual/manual-assets/application/%repo/file-manager/
%dir %_datadir/deepin-log-viewer/
%dir %_datadir/deepin-log-viewer/deepin-log.conf.d/
%_datadir/deepin-log-viewer/deepin-log.conf.d/*.json
%dir %_datadir/deepin-debug-config/
%dir %_datadir/deepin-debug-config/deepin-debug-config.d/
%_datadir/deepin-debug-config/deepin-debug-config.d/org.deepin.file-manager.json

%files -n lib%repo%soname
%_libdir/lib%repo.so.%version
%_libdir/lib%repo.so.%soname

%files -n lib%repo-devel
%_libdir/lib%repo.so

%files -n libdfm-extension%soname
%_libdir/libdfm-extension.so.%version
%_libdir/libdfm-extension.so.%soname

%files -n libdfm-extension-devel
%_includedir/dfm-extension/
%_libdir/libdfm-extension.so
%exclude %_pkgconfigdir/dfm-extension.pc
%_libdir/cmake/dfm-extension/

%files -n libdfm-base%soname
%_libdir/libdfm-base.so.%version
%_libdir/libdfm-base.so.%soname

%files -n libdfm-base-devel
%_libdir/libdfm-base.so
%exclude %_pkgconfigdir/dfm-base.pc
%_includedir/dfm-base/
%_libdir/cmake/dfm-base/

%files -n libdfm-framework%soname
%_libdir/libdfm-framework.so.%version
%_libdir/libdfm-framework.so.%soname

%files -n libdfm-framework-devel
%_libdir/libdfm-framework.so
%exclude %_pkgconfigdir/dfm-framework.pc
%_includedir/dfm-framework/
%_libdir/cmake/dfm-framework/

%files -n deepin-desktop
%_bindir/dde-desktop
%_desktopdir/dde-computer.desktop
%_desktopdir/dde-trash.desktop
%_desktopdir/dde-home.desktop
%_desktopdir/dde-open.desktop
%_datadir/dbus-1/services/com.deepin.dde.desktop.service

%changelog
