%def_disable clang
%def_disable tests
%define repo dde-printer

Name: deepin-printer
Version: 0.9.21
Release: alt1
Summary: Printing utility for DDE
License: GPL-3.0+
# src/cppcups/snmp.{c,h}: Apache-2.0
Group: Graphical desktop/Other
Url: https://github.com/linuxdeepin/dde-printer
Packager: Leontiy Volodin <lvol@altlinux.org>

Source: %url/archive/%version/%repo-%version.tar.gz

%if_enabled clang
BuildRequires: clang-devel lld-devel
%else
BuildRequires: gcc-c++
%endif
BuildRequires: dqt5-base-devel
BuildRequires: libcups-devel
BuildRequires: dqt5-tools
BuildRequires: dtk5-widget-devel
BuildRequires: libsmbclient-devel
BuildRequires: libusb-devel
BuildRequires: libgtest-devel
#Requires: icon-theme-hicolor

%description
Graphical interface to configure the printing system for DDE.

%prep
%setup -n %repo-%version

%build
export PATH=%_dqt5_bindir:$PATH
%if_enabled clang
export CC=clang
export CXX=clang++
export LDFLAGS="-fuse-ld=lld $LDFLAGS"
%endif
%qmake_dqt5 \
%if_enabled clang
  QMAKE_STRIP= -spec linux-clang \
%endif
  DEFINES+="VERSION=%version" \
  CONFIG+=nostrip \
  QMAKE_RPATHDIR=%_dqt5_libdir \
#
%make_build

%install
%makeinstall INSTALL_ROOT=%buildroot
%find_lang %repo
chmod +x %buildroot%_sysconfdir/xdg/autostart/%repo-watch.desktop

%files -f %repo.lang
%doc README.md LICENSE
%_bindir/%repo
%_bindir/%repo-helper
%_datadir/%repo/
%_datadir/%repo-helper/
%_desktopdir/%repo.desktop
%_sysconfdir/xdg/autostart/%repo-watch.desktop
%_iconsdir/hicolor/48x48/apps/%repo.svg
%_datadir/polkit-1/actions/com.deepin.pkexec.devPrinter.policy
%dir %_datadir/deepin-manual/
%dir %_datadir/deepin-manual/manual-assets/
%dir %_datadir/deepin-manual/manual-assets/application/
%dir %_datadir/deepin-manual/manual-assets/application/%repo/
%_datadir/deepin-manual/manual-assets/application/%repo/print-manager/

%changelog
