Name: deja-dup
Version: 45.2
Release: alt1

Summary: Simple backup tool and frontend for duplicity

License: GPLv3+
Group: Archiving/Other
Url: https://gitlab.gnome.org/World/deja-dup

# Source-url: https://gitlab.gnome.org/World/deja-dup/-/archive/%version/deja-dup-%version.tar.bz2
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-meson

BuildRequires: meson
BuildRequires: gettext gettext-tools desktop-file-utils intltool itstool
BuildRequires: libvala-devel >= 0.36 vala

# dependency generated by 'epm restore --dry-run' from deja-dup/meson.build
BuildRequires: pkgconfig(libadwaita-1) >= 1.2
BuildRequires: pkgconfig(gio-2.0) >= 2.70
BuildRequires: pkgconfig(gio-unix-2.0)
BuildRequires: pkgconfig(gpg-error) >= 1.33
BuildRequires: pkgconfig(gtk4) >= 4.6
#BuildRequires: pkgconfig(gtk4-wayland)
BuildRequires: pkgconfig(gtk4-x11)
BuildRequires: pkgconfig(json-glib-1.0) >= 1.2
BuildRequires: pkgconfig(packagekit-glib2) >= 1.2
BuildRequires: pkgconfig(libsecret-1) >= 0.18.6
BuildRequires: pkgconfig(libsoup-3.0) >= 3.0

BuildRequires: %_bindir/desktop-file-validate

#Requires: duplicity >= 0.7.14
# duplicity -V was broken before
Requires: duplicity >= 1.2.2-alt2

Requires: python3(gi)
#Requires: python3-module-pygobject3 python3-module-pygobject3-pygtkcompat

Requires: python3-module-pydrive2
Requires: fuse-gvfs

%description
DA.jA. Dup is a simple backup tool. It hides the complexity of doing backups the
'right way' (encrypted, off-site, and regular) and uses duplicity as the
backend.

Features:
 a.. Support for local, remote, or consumer cloud backup locations (Google Drive, etc)
 a.. Securely encrypts and compresses your data
 a.. Incrementally backs up, letting you restore from any particular backup
 a.. Schedules regular backups
 a.. Integrates well into your GNOME desktop

%prep
%setup

%build
%meson -Denable_borg=true -Denable_restic=true \
    -Dgvfs_pkgs=gvfs-backends,python3-module-pygobject3 \
    -Dpydrive_pkgs=python3-module-pydrive2 \
    -Drequests_oauthlib_pkgs=python3-module-requests-oauthlib \
    %nil

%meson_build

%install
%meson_install
rm -f %buildroot/%_libdir/deja-dup/*.la

desktop-file-validate %buildroot/%_desktopdir/org.gnome.DejaDup.desktop
desktop-file-validate %buildroot/%_sysconfdir/xdg/autostart/org.gnome.DejaDup.Monitor.desktop

#appstream-util validate-relax --nonet %buildroot/%_datadir/metainfo/*.appdata.xml

%find_lang %name --with-gnome

%files -f %name.lang
%doc --no-dereference LICENSES/
%doc NEWS.md README.md
%_bindir/deja-dup
%_man1dir/deja-dup.1*
%_datadir/glib-2.0/schemas/org.gnome.DejaDup.gschema.xml
%_sysconfdir/xdg/autostart/org.gnome.DejaDup.Monitor.desktop
%_libdir/deja-dup/
%_libexecdir/deja-dup/
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/org.gnome.DejaDup*
%_datadir/dbus-1/services/org.gnome.DejaDup.service
%_datadir/metainfo/org.gnome.DejaDup.metainfo.xml
#_datadir/help/*

%changelog
