Name: desmume
Version: 0.9.13
Release: alt1
Summary: A Nintendo DS emulator
Group: Emulators
License: GPLv2+
Url: http://desmume.org/
# http://downloads.sourceforge.net/%%name/%%name-%%version.tar.gz
Source: %name-%version.tar.gz
# Fix format strings
Patch0: %{name}-0.9.13-formatstring.patch
# Use system tinyxml instead of the embedded copy
Patch1: %{name}-0.9.13-tinyxml.patch
# Fix building on aarch64
# https://github.com/TASEmulators/desmume/issues/551
Patch2: %{name}-0.9.13-aarch64.patch
#Fix building on ppc64le
# https://github.com/TASEmulators/desmume/issues/550
Patch3: %{name}-0.9.13-ppc64le.patch
Patch4: %{name}-0.9.13-arm.patch

BuildRequires: meson
BuildRequires: libgtkglext-devel
BuildRequires: libglade-devel
BuildRequires: libopenal-devel
BuildRequires: liblua5-devel
BuildRequires: zziplib-devel
BuildRequires: gettext
BuildRequires: intltool
BuildRequires: gcc-c++ libpcap-devel
BuildRequires: desktop-file-utils
BuildRequires: libSDL2-devel
BuildRequires: pkgconfig(tinyxml)
BuildRequires: pkgconfig(glib-2.0)
BuildRequires: pkgconfig(sdl2)
BuildRequires: pkgconfig(gtk+-3.0)
Requires: icon-theme-hicolor
BuildPreReq: chrpath



%package cli
Summary: A Nintendo DS emulator (CLI version)
Group: Emulators

%description
DeSmuME is a Nintendo DS emulator running homebrew demos and commercial games.


%description cli
DeSmuME is a Nintendo DS emulator running homebrew demos and commercial games.

This is the CLI version.

%prep
%setup -q -n %name-release_0_9_13
%patch -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

pushd desmume

# Remove bundled tinyxml
rm -rf src/utils/tinyxml

# Fix end-of-line encoding
sed -i 's/\r//' AUTHORS

# Fix file encoding
for txtfile in ChangeLog AUTHORS
do
    iconv --from=ISO-8859-1 --to=UTF-8 $txtfile > tmp
    touch -r $txtfile tmp
    mv tmp $txtfile
done

# Fix premissions
find src -name '*.cpp' -exec chmod -v 644 '{}' \;
find src -name '*.h' -exec chmod -v 644 '{}' \;


# Fix premissions
find src -name *.[ch]* -exec chmod 644 {} \;

popd


%build
pushd desmume/src/frontend/posix
%meson
%meson_build
popd

%install
pushd desmume/src/frontend/posix
%meson_install
popd


# Remove installed icon
#rm -f %buildroot%_datadir/pixmaps/DeSmuME.xpm

# Install icons
mkdir -p %buildroot%_datadir/icons/hicolor/32x32/apps
#install -m 644 src/gtk/DeSmuME.xpm %buildroot%_datadir/icons/hicolor/32x32/apps/
#install -m 644 src/gtk/DeSmuME.xpm %buildroot%_datadir/icons/hicolor/32x32/apps/DeSmuME-glade.xpm


%find_lang %name

%files -f %name.lang
%_bindir/%name
%_datadir/icons/hicolor/*/apps/*DeSmuME*
%_datadir/applications/*.desktop
%_datadir/metainfo/*.xml
%_mandir/man1/%name.1*
%doc %name/AUTHORS %name/ChangeLog %name/COPYING %name/README %name/README.LIN

%files cli
%_bindir/%name-cli
%_mandir/man1/%name-cli.1*

%changelog
