# INFO: For update, do git merge -s ours with new tag from upstream repo
# TODO: build new release with poppler for PDF import (experimental)

Name: dia
Version: 0.97.4
Release: alt0.9

Summary: A gtk+ based diagram creation program
Summary(ru_RU.UTF-8): Программа для создания диаграмм, основанная на GTK+

License: GPLv2
Group: Office
Url: https://wiki.gnome.org/Apps/Dia

Obsoletes: %name-gnome %name-python

# Source-git: https://gitlab.gnome.org/GNOME/dia.git
Source: %name-%version.tar
Source2: ru.po

#Patch: %name-%version-%release.patch
Patch: alt-dia-fix-help.patch
Patch2: alt-dia-improve-translation.patch
Patch3: CVE-2019-19451-adapted-fix.patch

BuildRequires: pkgconfig(gtk+-2.0) pkgconfig(libxml-2.0) pkgconfig(libart-2.0)
BuildRequires: gcc-c++ libfreetype-devel libpng-devel
BuildRequires: intltool gettext
# for HTML doc
BuildRequires: docbook-utils docbook-style-dsssl docbook-style-xsl xsltproc
BuildRequires: desktop-file-utils

%ifnarch %e2k %mips
BuildRequires: libEMF-devel
%endif

%description
Dia is a GNU program designed to be much like the Windows
program 'Visio'. It can be used to draw different kind of diagrams.

It can be used to draw a variety of diagram types, including UML, Network,
flowchart and others.  The native file format for Dia is XML (optionally
gzip compressed).  It has print support, and can export to a number of
formats such as EPS, SVG, CGM and PNG.

%description -l ru_RU.UTF-8
Программа Dia разработана как альтернатива Visio для Windows(TM). Dia
можно использовать для рисования различных типов диаграмм, она
включает поддержку структурных статических диаграмм UML (диаграмм
классов), моделирование отношений объектов и сетевых диаграмм. Dia
может загружать и сохранять диаграммы в собственном формате и в
формате .xml, а также экспортировать их в различные форматы, такие как
PostScript(TM), SVG, CGM или PNG.

%prep
%setup
#patch -p1
%patch -p1
%patch2 -p1
%patch3 -p1

cp -f %SOURCE2 po/ru.po

install -m644 data/icons/48x48/apps/%name.png app/pixmaps/%name-app.png

# fixes from Fedora:
sed -i 's|libdia_la_LDFLAGS = -avoid-version|libdia_la_LDFLAGS = -avoid-version $(shell pkg-config --libs gtk+-2.0 libxml-2.0 libart-2.0)|' \
  lib/Makefile.*
chmod -x `find objects/AADL -type f`
iconv -f WINDOWS-1252 -t UTF8 doc/en/usage-layers.xml > usage-layers.xml.UTF-8
mv usage-layers.xml.UTF-8 doc/en/usage-layers.xml

%build
# TODO: remove autoreconf when will build from a tarball
%autoreconf
%configure  \
	--enable-db2html \
	--with-hardbooks \
	--disable-gnome \
	--without-python \
%ifarch x86_64 %e2k %mips
	--disable-libemf \
%endif
	--disable-static
%make_build

%install
%makeinstall_std
rm -rf %buildroot%_libdir/dia/*.la

%find_lang %name
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Graphics \
	--add-category=Office \
	--add-category=Chart \
	%buildroot%_desktopdir/dia.desktop

%files -f %name.lang
%doc README TODO NEWS AUTHORS
%_docdir/dia/
%docdir %_docdir/dia/
%_bindir/%name
%dir %_libdir/%name
%_libdir/%name/*.so
%_datadir/%name/
%_datadir/mime-info/*
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/%name.*
%_man1dir/*
%_mandir/fr/man1/*

%changelog
