%define git_commit 9763c0a1e2b9db0c3861d25bc2f5a0ace6a15ee3

%define enet_commit 2a85cd64459f6ba038d233a634d9440490dbba12
%define implot_version 0.16
%define rcheevos_version 11.4.0
%define tinygltf_commit c5641f2c22d117da7971504591a8f6a41ece488b
%define zlib_ng_commit ce01b1e41da298334f8214389cc9369540a7560f

Name: dolphin-emu
Version: 2503a
Release: alt1

Summary: The Gamecube / Wii Emulator
License: GPLv2
Group: Emulators

Url: https://%name.org/
Packager: Nazarov Denis <nenderus@altlinux.org>

ExclusiveArch: x86_64 aarch64

# https://github.com/%name/dolphin/archive/%version/dolphin-%version.tar.gz
Source0: dolphin-%version.tar
# https://github.com/lsalzman/enet/archive/%enet_commit/enet-%enet_commit.tar.gz
Source1: enet-%enet_commit.tar
# https://github.com/epezent/implot/archive/v%implot_version/implot-%implot_version.tar.gz
Source2: implot-%implot_version.tar
# https://github.com/RetroAchievements/rcheevos/archive/v%rcheevos_version/rcheevos-%rcheevos_version.tar.gz
Source3: rcheevos-%rcheevos_version.tar
# https://github.com/syoyo/tinygltf/archive/%tinygltf_commit/tinygltf-%tinygltf_commit.tar.gz
Source4: tinygltf-%tinygltf_commit.tar
# https://github.com/zlib-ng/zlib-ng/archive/$zlib_ng_commit/zlib-ng-%zlib_ng_commit.gz
Source5: zlib-ng-%zlib_ng_commit.tar

Patch0: dolphin-gbacore-alt.patch

BuildRequires: bzlib-devel
BuildRequires: cmake
BuildRequires: libSDL2-devel
BuildRequires: libSFML-devel
BuildRequires: libXi-devel
BuildRequires: libXrandr-devel
BuildRequires: libalsa-devel
BuildRequires: libavformat-devel
BuildRequires: libbluez-devel
BuildRequires: libcubeb-devel
BuildRequires: libcurl-devel
BuildRequires: libedit-devel
BuildRequires: libevdev-devel
BuildRequires: libffi-devel
BuildRequires: libfmt-devel
BuildRequires: libgtest-devel
BuildRequires: libhidapi-devel
BuildRequires: liblz4-devel
BuildRequires: liblzma-devel
BuildRequires: liblzo2-devel
BuildRequires: libmbedtls-compat-devel
BuildRequires: libmgba-devel
BuildRequires: libminiupnpc-devel
BuildRequires: libminizip-ng-compat-devel
BuildRequires: libpugixml-devel
BuildRequires: libpulseaudio-devel
BuildRequires: libspng-devel
BuildRequires: libswresample-devel
BuildRequires: libswscale-devel
BuildRequires: libsystemd-devel
BuildRequires: libudev-devel
BuildRequires: libusb-devel
BuildRequires: libvulkan-memory-allocator-devel
BuildRequires: libxml2-devel
BuildRequires: libxxhash-devel
BuildRequires: libzstd-devel
BuildRequires: llvm-devel
BuildRequires: llvm18.1-gold
BuildRequires: qt6-svg-devel
BuildRequires: zlib-devel

%description
Dolphin-emu is a emulator for Gamecube, Wii, Triforce that lets
you run Wii/GCN/Tri games on your Windows/Linux/Mac PC system.

%prep
%setup -n dolphin-%version -b 1 -b 2 -b 3 -b 4 -b 5

%__mv -Tf ../enet-%enet_commit Externals/enet/enet
%__mv -Tf ../implot-%implot_version Externals/implot/implot
%__mv -Tf ../rcheevos-%rcheevos_version Externals/rcheevos/rcheevos
%__mv -Tf ../tinygltf-%tinygltf_commit Externals/tinygltf/tinygltf
%__mv -Tf ../zlib-ng-%zlib_ng_commit Externals/zlib-ng/zlib-ng

%patch0 -p1

%build
export LDFLAGS="-Wl,--copy-dt-needed-entries"

#Generate Version Strings
echo "#define SCM_REV_STR \"%git_commit\"
#define SCM_DESC_STR \"%version\"
#define SCM_BRANCH_STR \"heads/refs/tags/%version\"
#define SCM_COMMITS_AHEAD_MASTER 0
#define SCM_DISTRIBUTOR_STR \"ALT Linux Team\"
#define SCM_UPDATE_TRACK_STR \"\"" > Source/Core/Common/scmrev.h.in

%cmake .. \
	-DENABLE_LTO:BOOL=TRUE \
	-Wno-dev

%cmake_build

%install
%cmake_install
%__install -Dp -m0644 Data/51-usb-device.rules %buildroot%_udevrulesdir/51-%name-usb-device.rules
%find_lang %name

%files -f %name.lang
%_bindir/*
%_desktopdir/%name.desktop
%_datadir/%name
%_iconsdir/hicolor/256x256/apps/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg
%_man6dir/%{name}*
%config %_udevrulesdir/51-%name-usb-device.rules

%changelog
