Name: doxygen
Version: 1.11.0
Release: alt1
Epoch: 1

Summary: Doxygen is a documentation system for C, C++ and IDL
License: GPLv2+
Group: Development/Other
Url: http://www.doxygen.org/

# ftp://ftp.stack.nl/pub/users/dimitri/doxygen-%version.src.tar.gz
Source: %name-%version.src.tar.gz
Source500: %name.unused

## Ubuntu patches
Patch101: Ubuntu-manpages.patch
Patch102: Ubuntu-dot-config.patch
Patch103: Ubuntu-no-timestamps.patch
Patch104: Ubuntu-avoid-compass.patch
Patch105: Ubuntu-fix-pdflatex-invocation.patch
Patch106: Ubuntu-faketime_pdflatex.patch
Patch107: Ubuntu-libatomic.patch
Patch108: Ubuntu-reproducible_manpages.patch
Patch109: Ubuntu-sass_fix.patch
Patch110: Ubuntu-gcc12.patch
Patch111: Ubuntu-0001-Fix-typo-in-generated-Makefile-for-LaTex.patch
Patch112: Ubuntu-filesystem_glibc.patch

## ALT patches

BuildRequires(pre): rpm-macros-qt5-webengine

# Automatically added by buildreq on Wed Mar 22 2023
# optimized out: cmake-modules fontconfig fonts-type1-urw gcc-c++ ghostscript-classic git-core glibc-kernheaders-generic glibc-kernheaders-x86 libglvnd-devel libgpg-error libqt5-core libqt5-gui libqt5-widgets libqt5-xml libsasl2-3 libssl-devel libstdc++-devel perl perl-parent python-modules python2-base python3 python3-base qt5-base-devel sh4 tex-common texlive texlive-collection-basic texlive-dist
BuildRequires: cmake flex ghostscript-common graphviz qt5-svg-devel qt5-virtualkeyboard-devel qt5-wayland-devel texlive-collection-basic texlive-dist

%ifarch %qt5_qtwebengine_arches
BuildRequires: qt5-webengine-devel qt5-webglplugin-devel
%endif

# graphviz uses pango as the default backend. pango needs some font and
# a properly configured fontconfig to produce something sane.
BuildRequires: fontconfig fonts-ttf-dejavu
Requires: fontconfig fonts-ttf-dejavu

%description
Doxygen is a documentation system for C, C++ and IDL.  It can generate
an on-line class browser (in HTML) and/or an off-line reference manual
(in LaTeX) from a set of documented source files.  There is also support
for generating man pages and for converting the generated output into
Postscript, hyperlinked PDF or compressed HTML.  The documentation is
extracted directly from the sources.

Doxygen can also be configured to extract the code-structure from
undocumented source files.  This can be very useful to quickly find
your way in large source distributions.

%package wizard
Summary: GUI frontend for doxygen
Group: Development/Other
Requires: %name = %epoch:%version-%release

%description wizard
Doxywizard is a GUI front-end for creating and editing
configuration files that are used by doxygen.

%package doc
Summary: Documentation and examples for doxygen
Group: Development/Other
BuildArch: noarch
Requires: %name = %epoch:%version-%release

%description doc
This package contains doxygen examples and documentation in html and
pdf formats.

%prep
%setup

## Remove junk
find * -name "*._*" -delete

## Ubuntu apply patches
%patch101 -p1
%patch102 -p1
##patch103 -p1
%patch104 -p1
#%%patch105 -p1
#patch106 -p1
%patch107 -p1
%patch108 -p1
%patch109 -p1
#patch110 -p1
##patch111 -p1
##patch112 -p1

## ALT apply patches

%build
%define _cmake__builddir BUILD
export QTDIR=%_libdir/qt4
export PATH="$QTDIR/bin:$PATH"

%cmake -G "Unix Makefiles" \
	-Dbuild_doc=ON -Dbuild_wizard=ON -Dbuild_xmlparser=ON \
	-Dbuild_search=OFF \
	-DMAN_INSTALL_DIR=%_mandir/man1 \
	-DDOC_INSTALL_DIR=share/doc/%name-%version \
	-DCMAKE_INSTALL_PREFIX:PATH=%prefix
%cmake_build

export NPROCS=1
%cmake_build -t docs

%install
%cmakeinstall_std

%check
cd BUILD && make tests

%files
%doc README.md
%_bindir/doxygen
%_man1dir/doxygen.*

%files wizard
%_bindir/doxywizard
%_man1dir/doxywizard.*

%files doc
%_defaultdocdir/%name-%version
%exclude %_defaultdocdir/%name-%version/README.md

%changelog
