%define qdoc_found %{expand:%%(if [ -e %_dqt5_bindir/qdoc ]; then echo 1; else echo 0; fi)}

%global qt_module dqtmultimedia
%def_disable bootstrap
%def_enable pulse

Name: dqt5-multimedia
Version: 5.15.13
Release: alt0.dde.1

Group: System/Libraries
Summary: Qt5 - Multimedia support
Url: http://qt.io/
License: LGPLv2 / GPLv3

Source: %qt_module-everywhere-src-%version.tar

BuildRequires(pre): rpm-build-ubt rpm-macros-dqt5
BuildRequires: gcc-c++ glibc-devel dqt5-base-devel dqt5-xmlpatterns-devel dqt5-declarative-devel
BuildRequires: pkgconfig(alsa)
BuildRequires: pkgconfig(gstreamer-1.0)
BuildRequires: pkgconfig(gstreamer-app-1.0)
BuildRequires: pkgconfig(gstreamer-audio-1.0)
BuildRequires: pkgconfig(gstreamer-base-1.0)
BuildRequires: pkgconfig(gstreamer-pbutils-1.0)
BuildRequires: pkgconfig(gstreamer-plugins-bad-1.0)
BuildRequires: pkgconfig(gstreamer-video-1.0)
%if_enabled pulse
BuildRequires: pkgconfig(libpulse) pkgconfig(libpulse-mainloop-glib)
%endif
BuildRequires: pkgconfig(openal)
BuildRequires: pkgconfig(xv)
%if_disabled bootstrap
BuildRequires(pre): dqt5-tools
%endif

# find libraries
%add_findprov_lib_path %_dqt5_libdir

%description
The Qt Multimedia module provides a rich feature set that enables you to
easily take advantage of a platforms multimedia capabilites and hardware.
This ranges from the playback and recording of audio and video content to
the use of available devices like cameras and radios.

%package common
Summary: Common package for %name
Group: System/Configuration/Other
BuildArch: noarch
Requires: dqt5-base-common
%description common
Common package for %name

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: dqt5-base-devel
%description devel
%summary.

%package devel-static
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: %name-devel
%description devel-static
%summary.

%package doc
Summary: Document for developing apps which will use Qt5 %qt_module
Group: Development/KDE and QT
Requires: %name-common = %EVR
%description doc
This package contains documentation for Qt5 %qt_module

%package -n libdqt5-multimedia
Summary: Qt5 library
Group: System/Libraries
Requires: %name-common = %EVR
Requires: libdqt5-core = %_dqt5_version
# gstreamer plugins may be required for proper audio and video playback
Requires: gst-plugins-base1.0 gst-plugins-good1.0 gst-plugins-bad1.0 gst-plugins-ugly1.0 gst-libav
Provides: dqt5-multimedia = %EVR
#Provides: qml(QtMultimedia)
AutoProv: no,lib
%description -n libdqt5-multimedia
%summary

%prep
%setup -n %qt_module-everywhere-src-%version
syncqt.pl-dqt5 -version %version

%build
%qmake_dqt5 GST_VERSION=1.0
%make_build
%if_disabled bootstrap
%if %qdoc_found
export QT_HASH_SEED=0
%make docs
%endif
%endif

%install
%install_dqt5
%if_disabled bootstrap
%if %qdoc_found
%make INSTALL_ROOT=%buildroot install_docs ||:
%endif
%endif


%files common

%files -n libdqt5-multimedia
%doc LICENSE*EXCEPT*
%_dqt5_libdir/libQt?Multimedia.so.*
%_dqt5_libdir/libQt?MultimediaQuick.so.*
%_dqt5_libdir/libQt?MultimediaWidgets.so.*
%_dqt5_libdir/libQt?MultimediaGstTools.so.*
%_dqt5_archdatadir/qml/QtAudioEngine/
%_dqt5_archdatadir/qml/QtMultimedia/
%_dqt5_plugindir/audio/
%_dqt5_plugindir/mediaservice/
%_dqt5_plugindir/playlistformats/

%files devel
%_dqt5_headerdir/QtMultimedia*/
%_dqt5_libdir/lib*.so
%_dqt5_libdatadir/lib*.so
%_dqt5_libdir/lib*.prl
%_dqt5_libdatadir/lib*.prl
%_dqt5_libdir/cmake/Qt*/
%_dqt5_libdir/pkgconfig/Qt*.pc
%_dqt5_archdatadir/mkspecs/modules/*.pri

%files doc
%if_disabled bootstrap
%if %qdoc_found
%_dqt5_docdir/*
%endif
%endif
%_dqt5_examplesdir/*

%changelog
