%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: dropbear
Summary: A smallish SSH server and client
Version: 2024.86
Release: alt1
License: MIT
# "Dropbear is open source software, distributed under a MIT-style license."
Group: System/Servers
Url: https://matt.ucc.asn.au/dropbear/dropbear.html
Vcs: https://github.com/mkj/dropbear

Source: %name-%version.tar
Source2: dropbear.service
Source3: dropbear.sysconfig

BuildRequires: zlib-devel
%{?!_without_check:%{?!_disable_check:
BuildRequires: iproute2
BuildRequires: python3-module-asyncssh
BuildRequires: python3-module-psutil
BuildRequires: python3-module-pytest-rerunfailures
BuildRequires: rpm-build-vm
BuildRequires: /usr/bin/pytest3
BuildRequires: /usr/bin/ssh-keygen
}}

%description
Dropbear is a relatively small SSH 2 server.

%package scp
Summary: Standalone scp program from OpenSSH
Group: %group

Conflicts: openssh-common

%description scp
The Dropbear distribution includes a standalone version of OpenSSH's scp
program.

%prep
%setup
cat > localoptions.h <<EOF
#define SFTPSERVER_PATH "/usr/lib/openssh/sftp-server"
EOF

%build
# --disable-harden: We have hardening enabled in GCC by default.
%ifarch x86_64 %ix86
# Additional upstream hardening for x86.
%add_optflags -mfunction-return=thunk -mindirect-branch=thunk
%endif
%configure --disable-harden
%make_build all scp SCPPROGRESS=1

%install
%makeinstall
install -D -m 0755 scp %buildroot%_bindir/scp
mkdir -p %buildroot%_sysconfdir/%name
install -Dpm644 %SOURCE2 %buildroot%_unitdir/%name.service
install -Dpm644 %SOURCE3 %buildroot%_sysconfdir/sysconfig/%name

%check
./dropbear -V |& grep -Fx 'Dropbear v%version'
./dropbearkey || : 'Listed key algorithms'
./dbclient -c help || : 'Listed ciphers'
./dbclient -m help || : 'Listed MACs'
./dropbearkey -t rsa -f dropbear_rsa_host_key
./dropbearkey -t ecdsa -f dropbear_ecdsa_host_key
./dropbearkey -t ed25519 -f dropbear_ed25519_host_key
# Upstream tend to enable DSS (ignoring config).
! ./dropbearkey | grep -iw DSS || exit 1
# Upstream testsuite.
vm-run --ext4 --heredoc <<-EOF
  cd test
  make fakekey
  HOME=/root
  mkdir -p ~/.ssh
  ../dropbearkey -t ecdsa -f ~/.ssh/id_dropbear | grep ^ecdsa > ~/.ssh/authorized_keys
  ../dropbearconvert dropbear openssh ~/.ssh/id_dropbear ~/.ssh/id_ecdsa
  chmod 700 ~/.ssh ~/.ssh/authorized_keys
  pytest3 --reruns=3 --hostkey=fakekey --dbclient=../dbclient --dropbear=../dropbear
EOF

%post
%post_service %name

%preun
%preun_service %name

%files
%define _customdocdir %_docdir/%name
%doc [A-Z][A-Z]*
%_bindir/dbclient
%_bindir/dropbearconvert
%_bindir/dropbearkey
%_sbindir/dropbear
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/sysconfig/%name
%_unitdir/%name.service
%_mandir/*/*

%files scp
%_bindir/scp

%changelog
