%define _unpackaged_files_terminate_build 1
%define icu_ver %(echo %{feature_icu} | tr -d .)

Name: edit
Version: 1.2.0
Release: alt2

Summary: A simple editor for simple needs

License: MIT
Group: Editors
Url: https://github.com/microsoft/edit

# Source-url: https://github.com/microsoft/edit/archive/refs/tags/v%version.tar.gz
Source: %name-%version.tar

Source1: %name-development-%version.tar

Patch: edit-1.2.0-alt-enable-debug-info-for-rpm.patch
Patch1: edit-1.2.0-alt-make-the-icu-soname-configurable.patch

BuildRequires(pre): rpm-macros-rust rpm-macros-features
BuildRequires: rpm-build-rust
Requires: libicu%icu_ver

%description
An editor that pays homage to the classic MS-DOS Editor, but with a modern interface and input controls similar to VS Code.

%prep
%setup -a1
%patch -p1
%patch1 -p1

cat >.cargo/config <<EOF
[source.crates-io]
replace-with = "vendored-sources"
[source.vendored-sources]
directory = "vendor"
EOF

%build
# allow nightly features
export RUSTC_BOOTSTRAP=1

export EDIT_CFG_ICUUC_SONAME=libicuuc.so.%icu_ver
export EDIT_CFG_ICUI18N_SONAME=libicui18n.so.%icu_ver
export EDIT_CFG_ICU_RENAMING_VERSION=%icu_ver

%rust_build

%install
install -Dm 755 target/release/edit -t %buildroot%_bindir

%check
export RUSTC_BOOTSTRAP=1
%rust_test

%files
%_bindir/edit
%doc LICENSE

%changelog
