%define _libexecdir %_prefix/libexec
%define oldname eog2
%define ver_major 47
%define beta %nil
%define xdg_name org.gnome.eog
%define api_ver 3.0
%define namespace Eog

%def_enable color_management
%def_enable introspection
%def_enable libportal
%def_enable gtk_doc
# python-behave required
%def_disable installed_tests

Name: eog
Version: %ver_major.0
Release: alt1%beta

Summary: Eye Of Gnome
License: GPL-2.0-or-later
Group: Graphics
Url: https://wiki.gnome.org/Apps/EyeOfGnome

Source: %gnome_ftp/%name/%ver_major/%name-%version%beta.tar.xz

Provides: %oldname = %EVR
Obsoletes: %oldname < 2.14.2-alt1

%add_findprov_lib_path %_libdir/%name
%set_typelibdir %_libdir/%name/girepository-1.0
%set_girdir %_datadir/%name/gir-1.0

%add_python3_path %_libdir/%name/plugins

%define glib_ver 2.74
%define peas_ver 0.7.4
%define portal_ver 0.5
%define gtk_ver 3.24.15
%define handy_ver 1.5
%define rsvg_ver 2.44
%define exempi_ver 1.99.5

BuildRequires(pre): rpm-macros-meson rpm-build-gnome
BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: meson python3-devel yelp-tools libappstream-glib-devel
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libgnome-desktop3-devel >= 3.0
BuildRequires: gnome-icon-theme >= 2.19.1
BuildRequires: shared-mime-info >= 0.60
BuildRequires: libexempi-devel >= %exempi_ver
BuildRequires: libexif-devel >= 0.6.14
%{?_enable_color_management:BuildRequires: liblcms2-devel}
%{?_enable_gtk_doc:BuildRequires: gi-docgen}
BuildRequires: libjpeg-devel librsvg-devel >= %rsvg_ver
BuildRequires: libpeas-devel >= %peas_ver
BuildRequires: libXt-devel libxml2-devel perl-XML-Parser zlib-devel gsettings-desktop-schemas-devel
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= 0.10.2 libgtk+3-gir-devel}
%{?_enable_libportal:BuildRequires: libportal-gtk3-devel >= %portal_ver}
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver

%description
This is the Eye of GNOME, an image viewer program. It is meant to be
a fast and functional image viewer as well as an image cataloging
program.

%package devel
Summary: Development files for EOG viewer
Group: Development/GNOME and GTK+
Requires: %name = %EVR

%description devel
This package contains files necessary to develop plugins for Eye of GNOME.

%package devel-doc
Summary: Development documentation for EOG viewer
Group: Development/GNOME and GTK+
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
This package contains documentation necessary to develop plugins for Eye
of GNOME.

%package gir
Summary: GObject introspection data for the EOG
Group: System/Libraries
Requires: %name = %EVR

%description gir
GObject introspection data for the Eye of GNOME

%package gir-devel
Summary: GObject introspection devel data for the EOG
Group: System/Libraries
BuildArch: noarch
Requires: %name-gir = %EVR

%description gir-devel
GObject introspection devel data for the Eye of GNOME

%package tests
Summary: Tests for the EOG
Group: Development/Other
BuildArch: noarch
Requires: %name = %EVR

%description tests
This package provides tests programs that can be used to verify
the functionality of the EOG GUI.


%prep
%setup -n %name-%version%beta

%build
%meson \
    -Dlibexif=true \
    -Dxmp=true \
    -Dlibjpeg=true \
    -Dlibrsvg=true \
    %{subst_enable_meson_bool introspection introspection} \
    %{subst_enable_meson_bool color_management cms} \
    %{subst_enable_meson_bool libportal libportal} \
    %{subst_enable_meson_bool installed_tests installed_tests} \
    %{subst_enable_meson_bool gtk_doc gtk_doc}
%nil
%meson_build

%install
%meson_install
ln -sf %name/lib%name.so \
%buildroot%_libdir/lib%name.so

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%_desktopdir/*
%dir %_datadir/%name
%_datadir/%name/icons/
%dir %_libdir/%name
%_libdir/%name/lib%name.so
# symlink
%_libdir/lib%name.so
%dir %_libdir/%name/plugins/
%_libdir/%name/plugins/*.so
%_libdir/%name/plugins/*.plugin
%_iconsdir/hicolor/*/apps/%{xdg_name}*.*
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%config %_datadir/glib-2.0/schemas/%xdg_name.enums.xml
%_datadir/GConf/gsettings/eog.convert
%_datadir/metainfo/%name.appdata.xml
%doc AUTHORS HACKING MAINTAINERS NEWS
%doc README* THANKS TODO

%files devel
%dir %_includedir/%name-%api_ver/%name
%_includedir/%name-%api_ver/%name/*.h
%_pkgconfigdir/%name.pc

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/%name
%endif

%if_enabled introspection
%files gir
%_libdir/%name/girepository-1.0/%namespace-%api_ver.typelib

%files gir-devel
%_datadir/%name/gir-1.0/%namespace-%api_ver.gir
%endif

%if_enabled installed_tests
%files tests
%_libexecdir/%name/installed-tests/
%_datadir/installed-tests/%name/
%endif


%changelog
