%define _unpackaged_files_terminate_build 1

Name: exodusii
Version: 6.09.0
Release: alt7.git20150119

Summary: A model developed to store and retrieve transient data for finite element analyses
License: BSD
Group: Sciences/Mathematics

Url: http://sourceforge.net/projects/exodusii/
# git://exodusii.git.sourceforge.net/gitroot/exodusii/exodusii
Source: %name-%version.tar
Patch0: port-on-python3.patch

ExclusiveArch: %ix86 x86_64 %e2k

%define somver 0
%define sover %somver.%version

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ gcc-fortran
BuildRequires: doxygen graphviz
BuildRequires: cmake imake
BuildRequires: libnetcdf-devel netcdf-tools libhdf5-devel
BuildRequires: libcurl-devel

%description
EXODUS II is a model developed to store and retrieve transient data for
finite element analyses. It is used for preprocessing, postprocessing,
as well as code to code data transfer. ExodusII is based on netcdf.
Includes the nemesis parallel extension.

%package -n lib%name
Summary: Shared libraries of EXODUS II
Group: System/Libraries

%description -n lib%name
EXODUS II is a model developed to store and retrieve transient data for
finite element analyses. It is used for preprocessing, postprocessing,
as well as code to code data transfer. ExodusII is based on netcdf.
Includes the nemesis parallel extension.

This package contains shared libraries of EXODUS II.

%package -n lib%name-devel
Summary: Development files of EXODUS II
Group: Development/C++
Requires: lib%name = %EVR

%description -n lib%name-devel
EXODUS II is a model developed to store and retrieve transient data for
finite element analyses. It is used for preprocessing, postprocessing,
as well as code to code data transfer. ExodusII is based on netcdf.
Includes the nemesis parallel extension.

This package contains development files of EXODUS II.

%package -n lib%name-devel-doc
Summary: Documentation for EXODUS II
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
EXODUS II is a model developed to store and retrieve transient data for
finite element analyses. It is used for preprocessing, postprocessing,
as well as code to code data transfer. ExodusII is based on netcdf.
Includes the nemesis parallel extension.

This package contains development documentation for EXODUS II.

%package -n python3-module-exodus
Summary: Python binding for EXODUS II
Group: Development/Python3
Requires: lib%name = %EVR

%description -n python3-module-exodus
EXODUS II is a model developed to store and retrieve transient data for
finite element analyses. It is used for preprocessing, postprocessing,
as well as code to code data transfer. ExodusII is based on netcdf.
Includes the nemesis parallel extension.

This package contains python binding for EXODUS II.

%prep
%setup
%patch0 -p1

%build
pushd exodus
%cmake_insource \
	-DSOMVER:STRING="%somver" \
	-DSOVER:STRING="%sover" \
	-DNETCDF_SO_ROOT=%_libdir \
	-DPYTHON_INSTALL=%python3_sitelibdir \
	-DNETCDF_INCLUDE_DIR:STRING="%_includedir" \
	-DNETCDF_LIBRARY:STRING=-lnetcdf \
	-DHDF5_LIBRARY:STRING=-lhdf5 \
	-DHDF5HL_LIBRARY:STRING=-lhdf5_hl \
	-DBUILD_TESTING:BOOL=OFF \
	-DEXODUS_LIBRARY:STRING=-lexoIIv2c \
	-DBUILD_SHARED:BOOL=ON \
	-DBUILD_SHARED_LIBS:BOOL=ON \
	%nil
%make_build VERBOSE=1
popd

pushd nemesis
%cmake_insource \
	-DSOMVER:STRING="%somver" \
	-DSOVER:STRING="%sover" \
	-DNETCDF_INCLUDE_DIR:STRING="%_includedir" \
	-DNETCDF_LIBRARY:STRING=-lnetcdf \
	-DHDF5_LIBRARY:STRING=-lhdf5 \
	-DHDF5HL_LIBRARY:STRING=-lhdf5_hl \
	-DBUILD_TESTING:BOOL=OFF \
	-DEXODUS_LIBRARY:STRING=-lexoIIv2c \
	-DBUILD_SHARED:BOOL=ON \
	-DBUILD_SHARED_LIBS:BOOL=ON \
	%nil

%make_build VERBOSE=1
popd

pushd exodus
doxygen
popd

%install
pushd exodus
%makeinstall_std
popd
pushd nemesis
%makeinstall_std
popd

install -d %buildroot%_includedir/%name
mv %buildroot%_includedir/*.h %buildroot%_includedir/%name/

mv nemesis/README README.Nemesis

%files -n lib%name
%doc exodus/COPYRIGHT exodus/README README.Nemesis ChangeLog
%_libdir/*.so.%{somver}
%_libdir/*.so.%{sover}

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*

%files -n lib%name-devel-doc
%doc exodus/html exodus/doc/*

%files -n python3-module-exodus
%python3_sitelibdir/*

%changelog
