Summary: Flat assembler
Name: fasm
Version: 1.73.30
Release: alt1
License: BSD-like
Group: Development/Tools
Source0: http://flatassembler.net/%name-%version.tgz
Url: http://flatassembler.net/
ExclusiveArch: %ix86

# Automatically added by buildreq on Wed Feb 08 2017
# optimized out: python-base
BuildRequires: fasm prelink glibc-devel-static

%description
The flat assembler is a fast and efficient self-assembling 80x86
assembler for DOS, Windows and Linux operating systems. Currently it
supports all 8086-80486/Pentium instructions with MMX, SSE, SSE2, SSE3
and 3DNow! extensions, can produce output in binary, MZ, PE, COFF or
ELF format. It includes the powerful but easy to use macroinstruction
support and does multiple passes to optimize the instruction codes for
size. The flat assembler is self-compilable and the full source code
is included.

%prep
%setup -n %name
sed -i 's/fopen/fopen64/g' source/libc/system.inc
sed -i 's/fopen/fopen64/g' tools/libc/system.inc
sed -i 's/cinvoke exit$/cinvoke exit, 0/' examples/elfexe/dynamic/hello.asm
sed -i '/ret$/i xor eax, eax' examples/libcdemo/libcdemo.asm
sed -i 's/gcc libcdemo.o/gcc -static libcdemo.o/' examples/libcdemo/libcdemo.asm

%build
find * -name \*.o -exec rm {} \;
%define FTOOLS listing prepsrc symbols
fasm source/Linux/fasm.asm fasm
for n in %FTOOLS; do
	./fasm tools/libc/$n.asm $n.o
	cc -static $n.o -o $n
	execstack -c $n
done

%install
install -Dm755 %name %buildroot%_bindir/%name
install %FTOOLS %buildroot%_bindir/

%check
./fasm examples/elfexe/hello.asm
examples/elfexe/hello | { read A; test "$A" = 'Hello world!'; }
./fasm examples/elfexe/dynamic/hello.asm
examples/elfexe/dynamic/hello | { read A; test "$A" = 'Hello world!'; }
./fasm examples/elfobj/msgdemo.asm
./fasm examples/elfobj/writemsg.asm
ld examples/elfobj/msgdemo.o examples/elfobj/writemsg.o -o examples/elfobj/msgdemo
examples/elfobj/msgdemo | { read A; test "$A" = 'Elves are coming!'; }
./fasm examples/libcdemo/libcdemo.asm
cc -static examples/libcdemo/libcdemo.o -o examples/libcdemo/libcdemo
examples/libcdemo/libcdemo >o &
wait
read A <o
test "$A" = "Current process ID is $!."

%files
%doc *.txt examples
%_bindir/*

%changelog
