# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1
%global srcname flawfinder

Name: flawfinder
Version: 2.0.19
Release: alt2

Summary: Examines C/C++ source code for security flaws
License: GPLv2+
Group: Development/Other

Url: http://www.dwheeler.com/flawfinder/
Source: http://www.dwheeler.com/%name/%name-%version.tar.gz

BuildArch: noarch
BuildRequires(pre): rpm-build-python3
BuildRequires: flex
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

Summary(ru_RU.UTF-8): Исследует исходный код на С/С++ на предмет ошибок в безопасности

%description
Flawfinder scans through C/C++ source code, identifying lines ("hits")
with potential security flaws. By default it reports hits sorted by
severity, with the riskiest lines first.

%description -l ru_RU.UTF-8
Flawfinder сканирует исходный код на С/С++, указывая на строки,
в которых содержатся возможные ошибки в безопасности. По умолчанию
программа выводит отчет, отсортированный по предполагаемой серьёзности
ошибок, где строки, требующие пристального внимания с вашей стороны,
располагаются в начале.

%prep
%setup
rm -f test-results.*
sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ \( -name '*.py' -o -name '%name' \))

%build
%make_build
%pyproject_build
%{?!_without_check:%{?!_disable_check:%make_build -k check ||:}}

%install
%pyproject_install
xz ChangeLog

%files
%python3_sitelibdir/%srcname-%version.dist-info/
%python3_sitelibdir/__pycache__/%{srcname}*.pyc
%python3_sitelibdir/%{srcname}.py
%_bindir/%name
%_man1dir/%name.1.*
%doc announcement README.md ChangeLog* *.pdf
%doc test/test.c test/test2.c
%{?!_without_check:%{?!_disable_check:%doc test/*.*}}

%changelog
