%global _unpackaged_files_terminate_build 1
%def_disable check

Name: fluent-bit
Version: 3.0.4
Release: alt1

Summary: Fast data collector for Linux

License: Apache-2.0
Group: Monitoring
Url: https://github.com/fluent/fluent-bit

Source: %name-%version.tar
# Fix up some install paths in CMake. Not upstream
Patch1: 0002-CMake-fix-up-install-paths.patch
# Add -fPIC to jemalloc build. Not upstream
Patch2: 0003-jemalloc-add-fPIC-to-CFLAGS.patch

ExcludeArch: armh ppc64le

BuildRequires(pre): rpm-macros-cmake
# Automatically added by buildreq on Fri Mar 22 2024
# optimized out: CUnit cmake-modules glibc-kernheaders-generic glibc-kernheaders-x86 libgpg-error libp11-kit libsasl2-3 libstdc++-devel pkg-config python3 python3-base sh5 xz
BuildRequires: gcc-c++ CUnit-devel cmake flex libcares-devel libedit-devel libev-devel libevent-devel libjansson-devel libjemalloc-devel libnghttp3-devel libngtcp2-devel libpq5-devel libsasl2-devel libssl-devel libsystemd-devel libxml2-devel libyaml-devel libzstd-devel zlib-devel
# libudev-devel BR is needed for systemd input plugin
BuildRequires: libudev-devel
%if_enabled check
BuildRequires: ctest
%endif
# temporarily in-source (by upstream)
# BuildRequires: libsqlite3-devel

%description
Fluent Bit is a fast Log Processor and Forwarder.
Its part of the Fluentd Ecosystem and a CNCF sub-project.
Fluent Bit allows to collect log events or metrics from different sources,
process them and deliver them to different backends such as
Fluentd, Elasticsearch, NATS, InfluxDB or any custom HTTP end-point within others.
In addition, Fluent Bit comes with full Stream Processing capabilities:
data manipulation and analytics using SQL queries.

%prep
%setup
%patch1 -p1
%patch2 -p1
sed -i 's|c-ares|cares|' \
    src/CMakeLists.txt
sed -i '/FLB_PATH_LIB_CARES/d' \
    CMakeLists.txt \
    cmake/headers.cmake \
    cmake/libraries.cmake
sed -i '/include(ExternalProject)/i include(CheckIncludeFiles)' \
    CMakeLists.txt

%build
%cmake \
    -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DPACKAGE_VERSION=%version \
    -DFLB_EXAMPLES=Off \
    -DFLB_OUT_SLACK=Off \
    -DFLB_IN_SYSTEMD=On \
    -DFLB_OUT_TD=Off \
    -DFLB_OUT_ES=On \
    -DFLB_OUT_PGSQL=On \
    -DFLB_OUT_KAFKA=On \
    -DFLB_IN_KAFKA=On \
    -DFLB_SHARED_LIB=Off \
    -DFLB_TESTS_RUNTIME=On \
    -DFLB_TESTS_INTERNAL=Off \
    -DFLB_RELEASE=On \
    -DFLB_DEBUG=Off \
    -DFLB_TLS=On \
    -DFLB_LUAJIT=Off \
    -DFLB_FILTER_LUA=Off \
    -DFLB_HTTP_SERVER=On \
    -DFLB_CONFIG_YAML=On \
#

%cmake_build

%install
%cmake_install
# We don't ship headers and shared library for plugins (yet)
rm -rvf %buildroot%_includedir

%check
cd %_target_alias
ctest

%post
%post_service %name.service

%preun
%preun_service %name.service

%files
%doc LICENSE README.md MAINTAINERS.md CODE_OF_CONDUCT.md CONTRIBUTING.md GOLANG_OUTPUT_PLUGIN.md GOVERNANCE.md
%doc conf
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/*.conf
%_bindir/%name
%_unitdir/%name.service

%changelog
