Group: System/Fonts/True type
# BEGIN SourceDeps(oneline):
BuildRequires: unzip
# END SourceDeps(oneline)
%define oldname oflb-goudy-bookletter-1911-fonts
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global fontname oflb-goudy-bookletter-1911
%global fontconf 61-%{fontname}.conf

Name:		fonts-otf-oflb-goudy-bookletter-1911
Summary:	Clean serif font based on Kennerly Old Style
Version:	20080206
Release:	alt3_14
License:	Public Domain
# Source was originally downloaded from here:
# http://openfontlibrary.org/people/chemoelectric/chemoelectric_-_Goudy_Bookletter_1.zip
# It is no longer available. The main website has this zip for download:
# http://home.comcast.net/%7Ecrudfactory/cf3/fonts/GoudyBookletter1911--2008.02.06.zip
# But, it doesn't have the source, just an otf.
Source0:	chemoelectric_-_Goudy_Bookletter_1.zip
Source1:	%{oldname}-fontconfig.conf
Source2:	GoudyBookletter1911.otf
Source3:        %{fontname}.metainfo.xml

URL:		http://home.comcast.net/~crudfactory/cf3/gb1911.html
BuildRequires:	fontpackages-devel fontforge libfontforge
BuildArch:	noarch
Source44: import.info

%description
Based on the roman of Frederic Goudy's Kennerley Old Style (designed and cut in
1911 for a limited edition of "The Door in the Wall and Other Stories" by H G
Wells, published by Mitchell Kennerley). The letters, though not condensed, may
seem to fit together like pieces of a jigsaw puzzle, giving text an unusually
solid appearance.

%prep
%setup -q -c -n %{oldname}
sed -i 's|/home/trashman/bin/fontforge|/usr/bin/fontforge|g' make-otf.py

%build
# Fontforge's python support is broken, so we can't build this from source, sadly.
# ./generate-it.sh
# The otf file was generated by converting it with Fontforge manually.
cp %{SOURCE2} .

%install
install -m 0755 -d %{buildroot}%{_fontdir}
install -m 0644 -p *.otf %{buildroot}%{_fontdir}
install -m 0755 -d %{buildroot}%{_fontconfig_templatedir} %{buildroot}%{_fontconfig_confdir}
install -m 0644 -p %{SOURCE1} %{buildroot}%{_fontconfig_templatedir}/%{fontconf}
ln -s %{_fontconfig_templatedir}/%{fontconf} %{buildroot}%{_fontconfig_confdir}/%{fontconf}

# Add AppStream metadata
install -Dm 0644 -p %{SOURCE3} \
        %{buildroot}%{_datadir}/appdata/%{fontname}.metainfo.xml
# generic fedora font import transformations
# move fonts to corresponding subdirs if any
for fontpatt in OTF TTF TTC otf ttf ttc pcf pcf.gz bdf afm pfa pfb; do
    case "$fontpatt" in 
	pcf*|bdf*) type=bitmap;;
	tt*|TT*) type=ttf;;
	otf|OTF) type=otf;;
	afm*|pf*) type=type1;;
    esac
    find $RPM_BUILD_ROOT/usr/share/fonts -type f -name '*.'$fontpatt | while read i; do
	j=`echo "$i" | sed -e s,/usr/share/fonts/,/usr/share/fonts/$type/,`;
	install -Dm644 "$i" "$j";
	rm -f "$i";
	olddir=`dirname "$i"`;
	mv -f "$olddir"/{encodings.dir,fonts.{dir,scale,alias}} `dirname "$j"`/ 2>/dev/null ||:
	rmdir -p "$olddir" 2>/dev/null ||:
    done
done
# kill invalid catalogue links
if [ -d $RPM_BUILD_ROOT/etc/X11/fontpath.d ]; then
    find -L $RPM_BUILD_ROOT/etc/X11/fontpath.d -type l -print -delete ||:
    # relink catalogue
    find $RPM_BUILD_ROOT/usr/share/fonts -name fonts.dir | while read i; do
	pri=10;
	j=`echo $i | sed -e s,$RPM_BUILD_ROOT/usr/share/fonts/,,`; type=${j%%%%/*}; 
	pre_stem=${j##$type/}; stem=`dirname $pre_stem|sed -e s,/,-,g`;
	case "$type" in 
	    bitmap) pri=10;;
	    ttf|ttf) pri=50;;
	    type1) pri=40;;
	esac
	ln -s /usr/share/fonts/$j $RPM_BUILD_ROOT/etc/X11/fontpath.d/"$stem:pri=$pri"
    done ||:
fi

%files
%{_fontconfig_templatedir}/%{fontconf}
%config(noreplace) %{_fontconfig_confdir}/%{fontconf}
%{_fontbasedir}/*/%{_fontstem}/*.otf
%{_datadir}/appdata/%{fontname}.metainfo.xml

%changelog
