Name: freeciv
Version: 2.6.0
Release: alt1

Summary: Turn-based strategy game inspired by the history of human civilization
License: GPLv2+
Group: Games/Strategy
Url: http://www.freeciv.org/

%define srcname %name-%version%{?beta_ver:-beta%beta_ver}
# http://download.sourceforge.net/freeciv/%srcname.tar.bz2
Source0: %srcname.tar
Source1: freeciv-wrapper
# git://git.altlinux.org/gears/f/freeciv.git
Patch: freeciv-%version-%release.patch

Requires: %name-client = %version-%release
Requires: %name-server = %version-%release

%def_enable gtk2
%def_disable gtk3

%{?_enable_gtk2:BuildPreReq: libgtk+2-devel}
%{?_enable_gtk3:BuildPreReq: libgtk+3-devel}

# Automatically added by buildreq on Tue Aug 09 2011 (-bi)
# optimized out: elfutils fontconfig fontconfig-devel glib2-devel libX11-devel libatk-devel libcairo-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libpango-devel libstdc++-devel pkg-config xorg-xproto-devel
BuildRequires: bzlib-devel gcc-c++ hardlink libcurl-devel liblzma-devel libreadline-devel zlib-devel

%package common
Summary: The Freeciv multi-player strategy game common files
Group: Games/Strategy
BuildArch: noarch
Provides: /usr/lib/freeciv/wrapper
Obsoletes: %name-manual < %version

%package -n lib%name
Summary: The Freeciv multi-player strategy game common library
Group: Games/Strategy

%package server
Summary: The Freeciv multi-player strategy game server
Group: Games/Strategy
Requires: %name-common = %version-%release
Requires: lib%name = %version-%release
Requires: %name-server-data = %version-%release

%package server-data
Summary: The Freeciv multi-player strategy game server data files
Group: Games/Strategy
BuildArch: noarch
Conflicts: %name-server < %version-%release

%package client
Summary: The Freeciv multi-player strategy game client
Group: Games/Strategy
Requires: %name-common = %version-%release
Requires: lib%name = %version-%release
Requires: %name-client-data = %version-%release
Provides: %name-client-gui = %version-%release
%if_enabled gtk2
Provides: %name-client-gtk2 = %version-%release
Obsoletes: %name-client-gtk2 < %version-%release
%endif
%if_enabled gtk3
Provides: %name-client-gtk3 = %version-%release
Obsoletes: %name-client-gtk3 < %version-%release
%endif

%package client-data
Summary: The Freeciv multi-player strategy game client data files
Group: Games/Strategy
BuildArch: noarch
Conflicts: %name-client < %version-%release

%description
Freeciv is a turn-based, multi-player, X based strategy game.  Freeciv
is generally comparable to, and has compatible rules with, the
Civilization II(R) game by Microprose(R).  In Freeciv, each player is
the leader of a civilization, and is competing with the other players
in order to become the leader of the greatest civilization.

%description common
Freeciv is a turn-based, multi-player, X based strategy game.  Freeciv
is generally comparable to, and has compatible rules with, the
Civilization II(R) game by Microprose(R).  In Freeciv, each player is
the leader of a civilization, and is competing with the other players
in order to become the leader of the greatest civilization.

This package contains files common for client ans server.

%description -n lib%name
Freeciv is a turn-based, multi-player, X based strategy game.  Freeciv
is generally comparable to, and has compatible rules with, the
Civilization II(R) game by Microprose(R).  In Freeciv, each player is
the leader of a civilization, and is competing with the other players
in order to become the leader of the greatest civilization.

This package contains a shared library for client ans server.

%description server
Freeciv is a turn-based, multi-player, X based strategy game.  Freeciv
is generally comparable to, and has compatible rules with, the
Civilization II(R) game by Microprose(R).  In Freeciv, each player is
the leader of a civilization, and is competing with the other players
in order to become the leader of the greatest civilization.

This package contains the Freeciv server.

%description server-data
Freeciv is a turn-based, multi-player, X based strategy game.  Freeciv
is generally comparable to, and has compatible rules with, the
Civilization II(R) game by Microprose(R).  In Freeciv, each player is
the leader of a civilization, and is competing with the other players
in order to become the leader of the greatest civilization.

This package contains the Freeciv server data files.

%description client
Freeciv is a turn-based, multi-player, X based strategy game.  Freeciv
is generally comparable to, and has compatible rules with, the
Civilization II(R) game by Microprose(R).  In Freeciv, each player is
the leader of a civilization, and is competing with the other players
in order to become the leader of the greatest civilization.

This package contains the Freeciv client.

%description client-data
Freeciv is a turn-based, multi-player, X based strategy game.  Freeciv
is generally comparable to, and has compatible rules with, the
Civilization II(R) game by Microprose(R).  In Freeciv, each player is
the leader of a civilization, and is competing with the other players
in order to become the leader of the greatest civilization.

This package contains the Freeciv client data files.

%prep
%setup -n %srcname
%patch -p1

%build
rm *.m4
%autoreconf

%configure \
	--enable-shared \
	--disable-static \
	--enable-server \
	--enable-client=no%{?_enable_gtk2:,gtk2}%{?_enable_gtk3:,gtk3.22} \
	--enable-fcmp=%{?_enable_gtk2:,gtk2}%{?_enable_gtk3:,gtk3} \
	--without-freeciv-manual \
	--disable-silent-rules
%make_build MSUBDIRS=

%install
%makeinstall_std MSUBDIRS=
rm %buildroot%_libdir/libfreeciv.so

install -pD -m755 %_sourcedir/freeciv-wrapper \
	%buildroot%_libexecdir/%name/wrapper
sed -i 's,@LIBEXECDIR@,%_libexecdir,g' \
	%buildroot%_libexecdir/%name/wrapper
mv %buildroot%_bindir/freeciv-server %buildroot%_libexecdir/%name/
ln -rs %buildroot%_libexecdir/%name/wrapper %buildroot%_bindir/freeciv-server

rm %buildroot%_bindir/freeciv-manual
rm %buildroot%_man6dir/freeciv-{gtk,manual,mp-,qt,ruledit,sdl,xaw}*.6
rm %buildroot%_datadir/locale/*/LC_MESSAGES/freeciv-ruledit.mo
%if_enabled gtk2
ln -s freeciv-client.6 %buildroot%_man6dir/freeciv-gtk2.6
ln -s freeciv-modpack.6 %buildroot%_man6dir/freeciv-mp-gtk2.6
%endif
%if_enabled gtk3
ln -s freeciv-gtk3.22 %buildroot%_bindir/freeciv-gtk3
ln -s freeciv-client.6 %buildroot%_man6dir/freeciv-gtk3.6
ln -s freeciv-modpack.6 %buildroot%_man6dir/freeciv-mp-gtk3.6
%endif

hardlink -cv %buildroot
%find_lang --output=%name.lang %name %name-nations

%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1

%files

%files common -f %name.lang
%dir %_libexecdir/%name
%_libexecdir/%name/wrapper
%dir %_datadir/%name
%_docdir/%name/

%files -n lib%name
%_libdir/libfreeciv.*

%files server
%config /etc/freeciv/database.lua
%_bindir/freeciv-server
%dir %_libexecdir/%name
%_libexecdir/%name/freeciv-server

%files server-data
%_datadir/appdata/%name-server.appdata.xml
%_desktopdir/%name-server.desktop
%_iconsdir/hicolor/*/apps/%name-server.png
%_man6dir/freeciv-server.*
%_datadir/%name/cimpletoon*
%_datadir/%name/civ*
%_datadir/%name/classic*
%_datadir/%name/default*
%_datadir/%name/experimental*
%_datadir/%name/hexemplio*
%_datadir/%name/multiplayer*
%_datadir/%name/nation
%_datadir/%name/override
%_datadir/%name/sandbox*
%_datadir/%name/scenarios
%_datadir/%name/stdmusic*
%_datadir/%name/toonhex*

%files client
%if_enabled gtk2
%_bindir/freeciv-gtk2
%_bindir/freeciv-mp-gtk2
%endif
%if_enabled gtk3
%_bindir/freeciv-gtk3.22
%_bindir/freeciv-gtk3
%_bindir/freeciv-mp-gtk3
%endif

%files client-data
%if_enabled gtk2
%_datadir/appdata/%name-gtk2.appdata.xml
%_desktopdir/%name-gtk2.desktop
%_man6dir/freeciv-gtk2.*
%_datadir/%name/freeciv.rc*
%endif
%if_enabled gtk3
%_datadir/appdata/%name-gtk3.22.appdata.xml
%_desktopdir/%name-gtk3.22.desktop
%_man6dir/freeciv-gtk3.*
%endif
%_iconsdir/hicolor/*/apps/%name-client.png
%_iconsdir/hicolor/*/apps/%name-modpack.png
%_pixmapsdir/%name-client.png
%_man6dir/freeciv-client.*
%_datadir/appdata/%name-mp-*.appdata.xml
%_desktopdir/%name-mp-*.desktop
%_man6dir/freeciv-modpack.*
%_man6dir/freeciv-mp-*
%_datadir/%name/amplio*
%_datadir/%name/buildings*
%_datadir/%name/flags
%_datadir/%name/gtk*
%_datadir/%name/helpdata.txt
%_datadir/%name/hex2t*
%_datadir/%name/isophex*
%_datadir/%name/misc
%_datadir/%name/stdsounds*
%_datadir/%name/themes
%_datadir/%name/*trident*
%_datadir/%name/wonders*

%changelog
