%define _unpackaged_files_terminate_build 1

Name: gambit
Version: 4.9.7
Release: alt4

Summary: Gambit-C Scheme programming system
License: Apache-2.0
Group: Development/Other

Url: http://www.iro.umontreal.ca/~gambit/

Packager: Paul Wolneykien <manowar@altlinux.org>

Conflicts: ghostscript-minimal < 8.64-alt5

Source0: %name-%version.tar
Source1: listmodules.sh

Patch0: gambit-4.9.7-fix-executable-path-test.patch
Patch1: gambit-4.9.5-rm-module-on-error.patch
Patch2: gambit-4.9.5-moduledir.patch

BuildRequires: makeinfo
BuildPreReq: alternatives

Requires: %name-modules-C = %version-%release

%description
Gambit-C includes a Scheme interpreter and a Scheme compiler which can be used
to build standalone executables. Because the compiler generates portable C
code it is fairly easy to port to any platform with a decent C compiler.

The Gambit-C system conforms to the R4RS and IEEE Scheme standards.  The full
numeric tower is implemented, including: infinite precision integers (bignums),
rationals, inexact reals (floating point numbers), and complex numbers.

%package -n emacs-gambit
Summary: Emacs mode for Gambit-C
Group: Editors
Requires: gambit emacs-common
BuildArch: noarch

%description -n emacs-gambit
Emacs mode for running Gambit-C

%package docs
Summary: Gambit-C manuals and examples
Group: Development/Documentation
Requires: gambit = %version-%release
BuildArch: noarch

%description docs
Gambit-C manuals ang examples

%package info
Summary: Gambit-C manual in info format
Group: Development/Documentation
Requires: gambit = %version-%release
BuildArch: noarch

%description info
Gambit-C manual in info format

%package modules
Summary: Modules for Gambit-C Scheme
Group: Development/Other

%description modules
Modules for Gambit-C Scheme (module sources).

%package modules-C
Summary: Natively precompiled modules for Gambit-C Scheme
Group: Development/Other
Requires: %name-modules

%description modules-C
Natively precompiled modules for Gambit-C Scheme.

%package modules-js
Summary: Modules for Gambit-C Scheme precompiled to JavaScript
Group: Development/Other
Requires: %name-modules

%description modules-js
Modules for Gambit-C Scheme precompiled to JavaScript.

%package devel
Summary: Development files for Gambit-C Scheme
Group: Development/Other
Requires: %name = %version-%release

%description devel
Development files for Gambit-C Scheme

%package devel-java
Summary: Development files for Gambit Scheme (Java backend)
Group: Development/Other
Requires: gambit = %version-%release

%description devel-java
Development files for Gambit Scheme (Java backend)

%package devel-php
Summary: Development files for Gambit Scheme (PHP backend)
Group: Development/Other
Requires: gambit = %version-%release
Requires: /usr/bin/php

%description devel-php
Development files for Gambit Scheme (PHP backend)

%package devel-python
Summary: Development files for Gambit Scheme (Python backend)
Group: Development/Other
Requires: gambit = %version-%release
Requires: /usr/bin/python3

%description devel-python
Development files for Gambit Scheme (Python backend)

%package devel-js
Summary: Development files for Gambit Scheme (JavaScript backend)
Group: Development/Other
Requires: %name = %version-%release
Requires: %name-modules-js = %version-%release
Requires: /usr/bin/node

%description devel-js
Development files for Gambit Scheme (JavaScript backend)

%package devel-ruby
Summary: Development files for Gambit Scheme (Ruby backend)
Group: Development/Other
Requires: gambit = %version-%release
Requires: /usr/bin/ruby

%description devel-ruby
Development files for Gambit Scheme (Ruby backend)

%package devel-arm
Summary: Development files for Gambit Scheme (ARM processor family)
Group: Development/Other
Requires: gambit = %version-%release

%description devel-arm
Development files for Gambit Scheme (ARM processor family)

%package devel-riscv
Summary: Development files for Gambit Scheme (RISC-V processor family)
Group: Development/Other
Requires: gambit = %version-%release

%description devel-riscv
Development files for Gambit Scheme (RISC-V processor family)

%package devel-x86
Summary: Development files for Gambit Scheme (x86 processor family)
Group: Development/Other
Requires: gambit = %version-%release

%description devel-x86
Development files for Gambit Scheme (x86 processor family)

%define moduledir %_libdir/%name
%define pkgdocdir %_docdir/%name-%version

%prep
%setup
%patch0 -p1
%patch1 -p2
%patch2 -p2

%build
%autoreconf

%ifarch %e2k
%add_optflags -D___LITTLE_ENDIAN -D___DONT_USE_builtin_setjmp
%endif

%add_optflags -O1
%configure --enable-single-host --enable-shared \
	   --disable-absolute-shared-libs \
	   --enable-dynamic-clib \
	   --docdir=%pkgdocdir \
	   --enable-moduledir=%moduledir \
	   --enable-trust-c-tco
%make_build

%install
%makeinstall_std
for f in $RPM_BUILD_ROOT%_bindir/scheme-*; do
    mv $f $f-%name
done

mkdir -p %buildroot%pkgdocdir/examples
cp -R examples/* %buildroot%pkgdocdir/examples/

find %buildroot%moduledir -type d -name 'demo*' | \
    while read d; do
	d_path="${d%%/*}"
	mkdir -p "%buildroot%pkgdocdir/examples/${d_path#%buildroot%moduledir/}"
	mv -v "$d" \
	   "%buildroot%pkgdocdir/examples/${d_path#%buildroot%moduledir/}/"
    done

install -d $RPM_BUILD_ROOT%_altdir
cat > $RPM_BUILD_ROOT%_altdir/%name <<EOF
%_bindir/scheme-r5rs		%_bindir/scheme-r5rs-gambit		10
%_bindir/scheme-r4rs		%_bindir/scheme-r4rs-gambit		10
%_bindir/scheme-srfi-0		%_bindir/scheme-srfi-0-gambit		10
%_bindir/scheme-ieee-1178-1990	%_bindir/scheme-ieee-1178-1990-gambit	10
EOF

%SOURCE1 %buildroot%moduledir module.list

%check
%make check GAMBOPT=~~lib=../lib

%files
%_altdir/*
%_bindir/*-%name
%_bindir/gsi*
%_bindir/six*
%_includedir/*.h
%_libdir/*.so*
%_man1dir/*.1.*
%dir %moduledir

%files -n emacs-gambit
%_emacslispdir/*

%files docs
%pkgdocdir/

%files info
%_infodir/*.info*

%files modules -f module.list
%files modules-C -f c_module.list
%files modules-js -f js_module.list

%files devel
%_bindir/gsc*
%_bindir/gambdoc
%_bindir/gambuild-C
%_bindir/gambvcs

%files devel-java
%_bindir/gambuild-java

%files devel-js
%_bindir/gambuild-js

%files devel-php
%_bindir/gambuild-php

%files devel-python
%_bindir/gambuild-python

%files devel-ruby
%_bindir/gambuild-ruby

%files devel-arm
%_bindir/gambuild-arm

%files devel-riscv
%_bindir/gambuild-riscv-32
%_bindir/gambuild-riscv-64

%files devel-x86
%_bindir/gambuild-x86
%_bindir/gambuild-x86-64

%changelog
