%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define ver_major 3.41
%define gcr_api_ver 3
%define gck_api_ver 1

%def_disable ssh_agent
%def_enable introspection
%def_enable gtk_doc
%def_enable check

Name: gcr
Version: %ver_major.2
Release: alt1

Summary: A GNOME crypto viewer and prompter
Group: Graphical desktop/GNOME
License: LGPLv2+
Url: https://wiki.gnome.org/Projects/GnomeKeyring

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: %name-libs = %EVR
Requires: libtasn1-utils
%{?_enable_ssh_agent:Requires: %_bindir/ssh-agent %_bindir/ssh-add}
%{?_disable_ssh_agent:Conflicts: gcr4 < 3.92.0}

%define glib_ver 2.44.0
%define gtk_ver 3.22
%define p11kit_ver 0.19.0
%define vala_ver 0.18.1
%define gcrypt_ver 1.4.5
%define secret_ver 0.20

BuildRequires(pre): rpm-macros-meson rpm-build-gir rpm-build-systemd
BuildRequires: meson python3 glib2-devel >= %glib_ver
BuildRequires: libp11-kit-devel >= %p11kit_ver libgtk+3-devel >= %gtk_ver
BuildRequires: libgcrypt-devel >= %gcrypt_ver libtasn1-devel libtasn1-utils libtasn1-utils gnupg2-gpg
BuildRequires: libvala-devel >= %vala_ver vala-tools
BuildRequires: libsecret-devel >= %secret_ver %_bindir/ssh-agent %_bindir/ssh-add
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgtk+3-gir-devel}
%{?_enable_gtk_doc:BuildRequires: gi-docgen}
%{?_enable_check:BuildRequires: /proc xvfb-run dbus-tools-gui %_bindir/ssh-keygen}

%description
GCR is a library for displaying certificates, and crypto UI, accessing
key stores. It also provides the viewer for crypto files on the GNOME
desktop.

GCK is a library for accessing PKCS#11 modules like smart cards, in a
(G)object oriented way.

%package libs
Summary: Development files for GCR
Group: System/Libraries

%description libs
GCR is a library for displaying certificates, and crypto UI, accessing
key stores. It also provides the viewer for crypto files on the GNOME
desktop.

GCK is a library for accessing PKCS#11 modules like smart cards, in a
(G)object oriented way.

%package libs-devel
Summary: Development files for GCR
Group: Development/C
Requires: %name-libs = %EVR

%description libs-devel
The gcr-devel package includes the header files for the GCR libraries.

%package libs-gir
Summary: GObject introspection data for GCR libraries
Group: System/Libraries
Requires: %name-libs = %EVR

%description libs-gir
GObject introspection data for GCR libraries.

%package libs-gir-devel
Summary: GObject introspection devel data for the GCR libraries
Group: System/Libraries
BuildArch: noarch
Requires: %name-libs-gir = %EVR
Requires: %name-libs-devel = %EVR

%description libs-gir-devel
GObject introspection devel data for the GCR libraries.

%package libs-vala
Summary: Vala language bindings for the GCR libraries
Group: Development/Other
BuildArch: noarch
Requires: %name-libs = %EVR

%description libs-vala
This package provides Vala language bindings for the GCR libraries.

%package libs-devel-doc
Summary: Development documentation for GCR libraries
Group: Development/Documentation
Conflicts: %name-libs < %version-%release
BuildArch: noarch

%description libs-devel-doc
This package contains development documentation for GCR libraries.


%prep
%setup

%build
%meson \
    %{?_disable_ssh_agent:-Dssh_agent=false} \
    %{?_disable_introspection:-Dintrospection=false} \
    %{?_disable_gtk_doc:-Dgtk_doc=false}
%nil
%meson_build

%install
%meson_install
%find_lang %name

%check
xvfb-run %__meson_test -t 2

%files -f %name.lang
%_bindir/%name-viewer
%_libexecdir/%name-prompter
%_libexecdir/%name-ssh-askpass
%{?_enable_ssh_agent:
%_libexecdir/%name-ssh-agent
%_userunitdir/%name-ssh-agent.service
%_userunitdir/%name-ssh-agent.socket}
%_datadir/applications/%name-viewer.desktop
%_datadir/applications/%name-prompter.desktop
%dir %_datadir/GConf
%dir %_datadir/GConf/gsettings
%_datadir/GConf/gsettings/org.gnome.crypto.pgp.convert
%_datadir/GConf/gsettings/org.gnome.crypto.pgp_keyservers.convert
%_datadir/glib-2.0/schemas/org.gnome.crypto.pgp.gschema.xml
%_datadir/icons/hicolor/*/apps/*
%_datadir/mime/packages/%name-crypto-types.xml
%_datadir/dbus-1/services/org.gnome.keyring.PrivatePrompter.service
%_datadir/dbus-1/services/org.gnome.keyring.SystemPrompter.service

%files libs
%_libdir/libgck-%gck_api_ver.so.*
%_libdir/lib%name-base-%gcr_api_ver.so.*
%_libdir/lib%name-ui-%gcr_api_ver.so.*

%files libs-devel
%_includedir/gck-%gck_api_ver
%_includedir/%name-%gcr_api_ver
%_libdir/libgck-%gck_api_ver.so
%_libdir/lib%name-base-%gcr_api_ver.so
%_libdir/lib%name-ui-%gcr_api_ver.so
%_pkgconfigdir/gck-%gck_api_ver.pc
%_pkgconfigdir/%name-%gcr_api_ver.pc
%_pkgconfigdir/%name-base-%gcr_api_ver.pc
%_pkgconfigdir/%name-ui-%gcr_api_ver.pc

%if_enabled gtk_doc
%files libs-devel-doc
%_datadir/doc/%name-%gcr_api_ver
%_datadir/doc/%name-ui-%gcr_api_ver
%_datadir/doc/gck-%gck_api_ver
%endif

%if_enabled introspection
%files libs-gir
%_typelibdir/Gck-%gck_api_ver.typelib
%_typelibdir/Gcr-%gcr_api_ver.typelib
%_typelibdir/GcrUi-%gcr_api_ver.typelib

%files libs-gir-devel
%_girdir/Gck-%gck_api_ver.gir
%_girdir/Gcr-%gcr_api_ver.gir
%_girdir/GcrUi-%gcr_api_ver.gir
%endif

%files libs-vala
%_vapidir/gck-%gck_api_ver.deps
%_vapidir/gck-%gck_api_ver.vapi
%_vapidir/%name-%gcr_api_ver.deps
%_vapidir/%name-%gcr_api_ver.vapi
%_vapidir/%name-ui-%gcr_api_ver.deps
%_vapidir/%name-ui-%gcr_api_ver.vapi
%_vapidir/pkcs11.vapi


%changelog
