%define        pkgname erubis

Name:          gem-%pkgname
Version:       2.7.0
Release:       alt5
Summary:       A fast and extensible eRuby implementation
License:       MIT
Group:         Development/Ruby
Url:           http://www.kuwata-lab.com/erubis/
Vcs:           https://github.com/kwatch/erubis.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*

%description
Erubis is a fast, secure, and very extensible implementation of eRuby.
It has the following features:
* Very fast, almost three times faster than ERB and about ten percent
  faster than eruby (implemented in C).
* File caching of converted Ruby script support.
* Auto escaping (sanitizing) support, it means that '<%%= %%>' can be
  escaped in default. It is desirable for web application.
* Spaces around '<%% %%>' are trimmed automatically only when '<%%' is at the
  beginning of line and '%%>' is at the end of line.
* Embedded pattern changeable (default '<%% %%>'), for example '[%% %%]' or
  '<? ?>' are available.
* Enable to handle Processing Instructions (PI) as embedded pattern (ex.
  '<?rb ... ?>'). This is desirable for XML/HTML than '<%% .. %%>' because
  the latter breaks HTML design but the former doesn't.
* Multi-language support (Ruby/PHP/C/Java/Scheme/Perl/Javascript).
* Context object available and easy to combine eRuby template with YAML
  datafile (see the below example).
* Print statement available.
* Easy to expand and customize in subclass
* Ruby on Rails support.
* Mod_ruby support.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для %gemname самоцвета.


%package       -n %pkgname
Summary:       Library file for %gemname gem
Summary(ru_RU.UTF-8): Библиотеки для самоцвета %gemname
Group:         Development/Ruby
BuildArch:     noarch

%description   -n %pkgname
Library file for %gemname gem.

%description   -n %pkgname -l ru_RU.UTF8
Библиотеки для %gemname самоцвета.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README*
%ruby_gemspec
%ruby_gemlibdir

%files         -n %pkgname
%doc README*
%_bindir/%gemname

%files         doc
%ruby_gemdocdir


%changelog
