%define        _unpackaged_files_terminate_build 1
%def_disable   check
%def_enable    doc
%def_enable    devel
%define        gemname rack

Name:          gem-rack
Epoch:         1
Version:       3.0.10
Release:       alt2
Summary:       Modular Ruby webserver interface
License:       MIT
Group:         Development/Ruby
Url:           https://rack.github.io/
Vcs:           https://github.com/rack/rack.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
Patch:         fix-digit-when-nil-body.patch
BuildRequires(pre): rpm-build-ruby
%if_enabled check
BuildRequires: gem(minitest-global_expectations) >= 0
BuildRequires: gem(bundler) >= 0
BuildRequires: gem(rake) >= 0
BuildRequires: gem(webrick) >= 0
BuildRequires: gem(rubocop) >= 0
BuildRequires: gem(rubocop-packaging) >= 0
BuildRequires: gem(rdoc) >= 0
BuildRequires: gem(minitest) >= 0
BuildRequires: gem(bake-test-external) >= 0.1.3
BuildConflicts: gem(bake-test-external) >= 1
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
%ruby_use_gem_dependency minitest >= 5.17.0,minitest < 6
%ruby_use_gem_dependency bake-test-external < 1
Obsoletes:     ruby-rack < %EVR
Provides:      ruby-rack = %EVR
Provides:      gem(rack) = 3.0.10


%description
Rack provides a minimal, modular and adaptable interface for developing web
applications in Ruby. By wrapping HTTP requests and responses in the simplest
way possible, it unifies and distills the API for web servers, web frameworks,
and software in between (the so-called middleware) into a single method
call.

You may need to install appropriate gem-rack-handler-XXX.


%if_enabled    doc
%package       -n gem-rack-doc
Version:       3.0.10
Release:       alt2
Summary:       Modular Ruby webserver interface documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета rack
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(rack) = 3.0.10

%description   -n gem-rack-doc
Modular Ruby webserver interface documentation files.

Rack provides a minimal, modular and adaptable interface for developing web
applications in Ruby. By wrapping HTTP requests and responses in the simplest
way possible, it unifies and distills the API for web servers, web frameworks,
and software in between (the so-called middleware) into a single method
call.

You may need to install appropriate gem-rack-handler-XXX.

%description   -n gem-rack-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета rack.
%endif


%if_enabled    devel
%package       -n gem-rack-devel
Version:       3.0.10
Release:       alt2
Summary:       Modular Ruby webserver interface development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета rack
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(rack) = 3.0.10
Requires:      gem(minitest-global_expectations) >= 0
Requires:      gem(bundler) >= 0
Requires:      gem(rake) >= 0
Requires:      gem(webrick) >= 0
Requires:      gem(rubocop) >= 0
Requires:      gem(rubocop-packaging) >= 0
Requires:      gem(rdoc) >= 0
Requires:      gem(minitest) >= 0
Requires:      gem(bake-test-external) >= 0.1.3
Conflicts:     gem(bake-test-external) >= 1

%description   -n gem-rack-devel
Modular Ruby webserver interface development package.

Rack provides a minimal, modular and adaptable interface for developing web
applications in Ruby. By wrapping HTTP requests and responses in the simplest
way possible, it unifies and distills the API for web servers, web frameworks,
and software in between (the so-called middleware) into a single method
call.

You may need to install appropriate gem-rack-handler-XXX.

%description   -n gem-rack-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета rack.
%endif


%prep
%setup
%autopatch

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README.md
%ruby_gemspec
%ruby_gemlibdir

%if_enabled    doc
%files         -n gem-rack-doc
%doc README.md
%ruby_gemdocdir
%endif

%if_enabled    devel
%files         -n gem-rack-devel
%doc README.md
%endif


%changelog
