%define        pkgname ruby-ldap

Name:          gem-%pkgname
Version:       0.9.20
Release:       alt4.2
Summary:       Ruby LDAP library
Group:         Development/Ruby
License:       BSD
Url:           https://github.com/bearded/ruby-ldap
Vcs:           https://github.com/bearded/ruby-ldap.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: libldap-devel
BuildRequires: libssl-devel
BuildRequires: libsasl2-devel

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Obsoletes:     %pkgname < %EVR
Provides:      %pkgname = %EVR

%description
Ruby/LDAP is an extension library for Ruby. It provides the interface
to some LDAP libraries (e.g. OpenLDAP, UMich LDAP, Netscape SDK,
ActiveDirectory). The common API for application development is
described in RFC1823 and is supported by Ruby/LDAP.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%package       devel
Summary:       Development environment for %gemname gem
Group:         Development/Ruby
BuildArch:     noarch

Requires:      libldap-devel
Requires:      libssl-devel
Requires:      libsasl2-devel

%description   devel
Development environment for %gemname gem.

%description   devel -l ru_RU.UTF8
Среда разработки для самоцвета %gemname.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README*
%ruby_gemspec
%ruby_gemextdir
%ruby_gemlibdir

%files         doc
%ruby_gemdocdir

%changelog
