%def_without bootstrap

%define ghc_version 9.2.8
%define ghc_major 9.2
%define _ghclibdir %_libdir/ghc-%version

# Bootstrap with the previous version
%if_with bootstrap
    %define build_ghc_major 9.0
    %define ghc_build_version 9.0.2
%else
    %define build_ghc_major 9.2
    %define ghc_build_version 9.2.8
%endif

%global build_flavour perf+debug_info

%global elf_methods unresolved=relaxed
%ifarch i586
    %global elf_methods %{?elf_methods} textrel=relaxed
%endif
%set_verify_elf_method %elf_methods

%def_with docs

Name: ghc%ghc_major
Version: %ghc_version
Release: alt4

Summary: Glasgow Haskell Compilation system
License: BSD-3-Clause and HaskellReport
Group: Development/Haskell
Url: http://haskell.org/ghc/

Source: %name-%version.tar
Source1: bootstrap-sources-%ghc_build_version.tar.gz
Source2: ghc.macros
Source10: get_libs_versions.sh

# Patches from 10 to 20 is for doc generation
# Order is important
Patch10: ghc9.0-backport-sphinx_changes.patch
Patch11: ghc9.0-backport-extlinks_modern_syntax.patch
Patch12: ghc9.0-backport-distutils_replace.patch
Patch13: ghc9.0-suse-sphinx7.patch

Patch15: ghc9.2-alt-docs_disable_failing_on_undefined_reference.patch

Patch20: ghc9.0-debian-no_missing_haddock_file_warning.patch

Requires: libffi-devel libgmp-devel

# <https://bugzilla.altlinux.org/show_bug.cgi?id=31576>:
Requires: glibc-gconv-modules

# The installed Haskell libs will be processed:
Requires(pre,postun): haskell-filetrigger

# For ghc-pkg with rpath running during install, see:
# https://www.altlinux.org/Hasher/FAQ
# https://lists.altlinux.org/pipermail/devel/2018-April/204171.html
# Not needed after rebuild with separate single directory for shared libraries
BuildRequires: /proc

BuildRequires: ghc%build_ghc_major-devel

# Macroses needed for libs subpackages
# (Pre) here to remove annoying warnings
BuildRequires(Pre): rpm-build-haskell-extra

BuildRequires: binutils-devel docbook-dtds docbook-style-xsl libelf-devel libffi-devel libgmp-devel libncurses-devel xsltproc

# Needs for build man
BuildRequires: python3-module-sphinx-sphinx-build-symlink

BuildRequires: alex
BuildRequires: happy

# Needs for setting correct RPATH
BuildRequires: patchelf

Provides: haskell(abi) = %version

%description
Haskell is a standard lazy functional programming language; the
current language version is Haskell 98, agreed in December 1998.

GHC is a state-of-the-art programming suite for Haskell.  Included is
an optimising compiler generating good code for a variety of
platforms, together with an interactive system for convenient, quick
development.  The distribution includes space and time profiling
facilities, a large collection of libraries, and support for various
language extensions, including concurrency, exceptions, and foreign
language interfaces (C, C++, whatever).

A wide variety of Haskell related resources (tutorials, libraries,
specifications, documentation, compilers, interpreters, references,
contact information, links to research groups) are available from the
Haskell home page at <http://www.haskell.org/>.

%package common
Summary: Selects the default version of Glasgow Haskell Compilation system
Group: Development/Haskell

Requires: %name = %EVR
Requires: rpm-macros-%{name}-common = %EVR

%description common
Install this package to select %version as the default version
of Glasgow Haskell Compiler.

It will make rpm-build-haskell use this version of GHC for
building other Haskell packages
(if their .spec refers to %%ghc_version and %%_ghclibdir).

%package -n rpm-macros-%{name}-common
Summary: Set of RPM macros for packaging %name-based applications
Group: Development/Other

BuildArch: noarch

Provides: rpm-macros-ghc-common = %EVR
Conflicts: rpm-macros-ghc-common < %EVR
Conflicts: rpm-macros-ghc-common > %EVR

%description -n rpm-macros-%{name}-common
Set of RPM macros for packaging %name-based applications for ALT Linux.
Install this package if you want to create RPM packages that use %name.

%package doc
Summary: Documentation for GHC
Group: Development/Haskell

%description doc
Preformatted documentation for the Glasgow Haskell Compiler
(GHC) and its libraries. Install it if you like to have local
access to the documentation in PostScript and HTML format.
Alternatively, the documentation is available online at
http://haskell.org/ghc/documentation.html

%package doc-index
Summary: GHC library documentation indexing
Group: Development/Haskell

BuildArch: noarch

%description doc-index
The package enables re-indexing of installed library documention.

# Generated by get_libs_subpackages.sh
# Each standart library separated to subpackages (devel and runtime)
%define basepkg_version 4.16.4.0
%ghc_lib_subpackage -n base -v %basepkg_version
%ghc_lib_subpackage -n array -v 0.5.4.0
%ghc_lib_subpackage -n binary -v 0.8.9.0
%ghc_lib_subpackage -n bytestring -v 0.11.4.0
%ghc_lib_subpackage -n Cabal -v 3.6.3.0
%ghc_lib_subpackage -n containers -v 0.6.5.1
%ghc_lib_subpackage -n deepseq -v 1.4.6.1
%ghc_lib_subpackage -n directory -v 1.3.6.2
%ghc_lib_subpackage -n exceptions -v 0.10.4
%ghc_lib_subpackage -n filepath -v 1.4.2.2
%ghc_lib_subpackage -n ghc-bignum -v 1.2
%ghc_lib_subpackage -n ghc-compact -v 0.1.0.0
%ghc_lib_subpackage -n ghc-prim -v 0.8.0
%ghc_lib_subpackage -n haskeline -v 0.8.2
%ghc_lib_subpackage -n hpc -v 0.6.1.0
%ghc_lib_subpackage -n integer-gmp -v 1.1
%ghc_lib_subpackage -n mtl -v 2.2.2
%ghc_lib_subpackage -n parsec -v 3.1.15.0
%ghc_lib_subpackage -n pretty -v 1.1.3.6
%ghc_lib_subpackage -n process -v 1.6.16.0
%ghc_lib_subpackage -n stm -v 2.5.0.2
%ghc_lib_subpackage -n terminfo -v 0.4.1.5
%ghc_lib_subpackage -n text -v 1.2.5.0
%ghc_lib_subpackage -n time -v 1.11.1.1
%ghc_lib_subpackage -n transformers -v 0.5.6.2
%ghc_lib_subpackage -n unix -v 2.7.2.2
%ghc_lib_subpackage -n xhtml -v 3000.2.2.1
%ghc_lib_subpackage -n ghc-boot -v 9.2.8
%ghc_lib_subpackage -n ghc-boot-th -v 9.2.8
%ghc_lib_subpackage -n ghc-heap -v 9.2.8
%ghc_lib_subpackage -n ghci -v 9.2.8
%ghc_lib_subpackage -n libiserv -v 9.2.8
%ghc_lib_subpackage -n template-haskell -v 2.18.0.0

# Added manually
%ghc_lib_subpackage -n ghc -v %ghc_version

%package devel
Summary: GHC development libraries meta package
Version: %ghc_version
Group: Development/Haskell

Requires: %name = %EVR
Requires: %name-common = %EVR
Requires: %ghc_devel_subpackages_list

%description devel
This is a meta-package for all the development library packages in GHC

%prep
%setup

%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1

%patch15 -p1

%patch20 -p1

%build
#Set target x86_64-unknown-linux
%define _configure_target %nil

# Fixed internal error in haddock (see git log d5b703f for details)
export LANG=en_US.UTF-8

# Building hadrian
python3 hadrian/bootstrap/bootstrap.py -s %SOURCE1

# Specify LD directrly
# Mainly needed for aarch64 build
# See git log 9349778 for details
export LD=ld.gold

# Building using hadrian
# bindist is almost not documented option
# So you'll have to trust that I'm doing it right
./boot
%configure --with-system-libffi --disable-unregisterised --disable-ld-override
# Workaround for the error 'Platform constants not available'
_build/bin/hadrian %_smp_mflags -V --docs=no-sphinx-pdfs --flavour=%build_flavour _build/stage1/lib/DerivedConstants.h

_build/bin/hadrian %_smp_mflags -V --docs=no-sphinx-pdfs --flavour=%build_flavour binary-dist-dir

%install
# Installing using hadrian
# bindist dir looks like _build/bindist/ghc-%%ghc_version-{Target_Triplet}
pushd _build/bindist/ghc-%ghc_version-*
%configure
%makeinstall_std
popd

%define docdir %_docdir/ghc-%version
GHC_PKGDIR=$(find %buildroot%_ghclibdir/lib/ -maxdepth 1 -name "*ghc-%ghc_version" -printf "%%f")

# generate fake .pkg configs for core packages.
# haskell.prov will convert them to package provides.
ghc_create_lib_pkgfile() {
        lib="$0"
        pkgid="$(basename "$lib")"
        name="$(echo $pkgid | sed 's|-[0-9.]*$||')"
        version="$(echo $pkgid | awk -F - '{print $NF}')"
        echo -e "name: $name\nversion: $version" > "$lib/$name.pkg"
}
export -f ghc_create_lib_pkgfile
find "%buildroot%_ghclibdir/lib/$GHC_PKGDIR" -mindepth 1 -maxdepth 1 -type d \
                                  | xargs -n 1 sh -c ghc_create_lib_pkgfile

cp -a LICENSE README.md %buildroot%docdir/

# touch our "ghost". ghc-pkg may create him later.
touch %buildroot%_ghclibdir/lib/package.conf.old

# Adding directory with dynamic libraries for ld
mkdir -p %buildroot%_sysconfdir/ld.so.conf.d
echo "%_ghclibdir/lib/$GHC_PKGDIR" > %buildroot%_sysconfdir/ld.so.conf.d/ghc-%version.conf

# Moving man to man_dir from bindist
mkdir -p %buildroot%_man1dir
mv %buildroot%docdir/users_guide/build-man/ghc.1 %buildroot%_man1dir/ghc-%ghc_version.1
rm -rf --dir %buildroot%docdir/users_guide

# Moving html doc in old ALT style
mv -t %buildroot%docdir %buildroot%docdir/html/*
rmdir %buildroot%docdir/html

# Cleaning package.conf.d from .conf.copy files
# They coincide with non-copy entirely
find %buildroot%_ghclibdir -name "*.conf.copy" -delete

# Setting in conf.d correct path to html documentation
find %buildroot%_ghclibdir -name "*.conf" | xargs sed -i 's!/html/!/!'

# Generate file lists for all subpackages
# expands to %%ghc_gen_filelist {NAME} {VERSION} for each package
# SOURCE10 means get_libs_versions.sh
%SOURCE10 %ghc_version | xargs -n 2 %ghc_gen_filelist
%ghc_gen_filelist ghc %version

# Moving include dir to proper place
mv -t %buildroot%_ghclibdir %buildroot%_includedir

# Adding rts lib to base package
find "%buildroot%_ghclibdir" -name "*rts*.so" \
                | sed "s|%buildroot||g" >> base-%basepkg_version-files.runtime

echo "%_ghclibdir/include/rts" >> base-%basepkg_version-files.devel
find "%buildroot%_ghclibdir" -name "rts*.conf" \
                | sed "s|%buildroot||g" >> base-%basepkg_version-files.devel

find "%buildroot%_ghclibdir" -name "rts-*" -type d \
                | sed "s|%buildroot||g" >> base-%basepkg_version-files.devel

# install and fix up the macros file
mkdir -p %buildroot%_rpmmacrosdir
install %SOURCE2 %buildroot%_rpmmacrosdir/ghc
sed -i 's/@GHC_VERSION@/%version/' %buildroot%_rpmmacrosdir/ghc

# For the correct way of ELF verification:
# ld by default doesn't recognize GHC libraries,
# because of incorrect RPATH in binaries.
# so we get errors and warnings.
# Manually setting rpath in binaries is the solution
find %buildroot%_ghclibdir/bin -type f | xargs -n 1 patchelf --set-rpath '$ORIGIN/../lib'"/$GHC_PKGDIR"

%files
%_ghclibdir/bin/*-9.2.8
%_ghclibdir/lib/bin/*
%_bindir/*-%version
%dir %_libdir/ghc-%version
%dir %docdir/
%dir %_ghclibdir/bin/
%_man1dir/ghc-%ghc_version.1*
%ghost %_ghclibdir/lib/package.conf.old
%dir %_ghclibdir/lib/package.conf.d
%dir %_ghclibdir/lib
%dir %_ghclibdir/lib/bin
%dir %_ghclibdir/lib/*-ghc-%ghc_version
%_ghclibdir/lib/package.conf.d/package.cache*
%_ghclibdir/lib/package.conf.d/.stamp
%_ghclibdir/lib/settings
%_ghclibdir/lib/template-hsc.h
%_ghclibdir/lib/ghcversion.h
%_ghclibdir/lib/ghcplatform.h
%_ghclibdir/lib/DerivedConstants.h
%_ghclibdir/lib/ghcautoconf.h
%_ghclibdir/lib/ghc-usage.txt
%_ghclibdir/lib/ghci-usage.txt
%_ghclibdir/lib/llvm-passes
%_ghclibdir/lib/llvm-targets
%_ghclibdir/lib/html
%_ghclibdir/lib/latex
%_sysconfdir/ld.so.conf.d/ghc-%version.conf
%docdir/LICENSE
%docdir/README.md
%_ghclibdir/include/
%exclude %_ghclibdir/include/rts

%files common
%_bindir/*
%_ghclibdir/bin/*
%exclude %_ghclibdir/bin/*-%version
%exclude %_bindir/*-%version

%files -n rpm-macros-%{name}-common
%_rpmmacrosdir/*

%files doc-index
%dir %docdir/libraries
%docdir/libraries/*.html
%docdir/libraries/*.js
%docdir/libraries/*.css
%docdir/libraries/*.png

%files doc
%dir %docdir
%docdir/users_guide
%docdir/Haddock
%docdir/archives
%docdir/index.html

%files devel

%changelog
