%global import_path code.gitea.io/gitea

%global _unpackaged_files_terminate_build 1
%def_enable tarball

Name:    gitea
Version: 1.24.5
Release: alt1

Summary: Git with a cup of tea, painless self-hosted git service

License: MIT
Group:   Development/Other
Url:     https://gitea.io

# https://github.com/go-gitea/gitea
Source: %name-%version.tar

Source2: gitea.service
Source3: gitea.service.d.conf
Source4: README.ALT

%if_disabled tarball
Patch1: %name-%version.patch
%endif
Patch2: ALT_config.patch
Patch3: disable-strip.patch

BuildRequires(pre): rpm-macros-golang
BuildRequires: rpm-build-golang golang >= 1.24
%if_disabled tarball
BuildRequires: npm >= 6.13.6-alt2 node >= 18.0.0 esbuild node-gyp go-bindata
%endif
BuildRequires: libpam-devel
BuildRequires: /proc

Requires: git-core

%description
The goal of this project is to make the easiest, fastest, and most painless way
of setting up a self-hosted Git service. It is similar to GitHub, Bitbucket,
and Gitlab. Gitea is a fork of Gogs.

%prep
# build the JavaScript and CSS files
# $ npm install
# $ rm -f node_modules/esbuild/bin/esbuild
# $ rm -rf node_modules/esbuild-linux*
# $ git add -f node_modules
# $ git commit -n --no-post-rewrite -m "add node js modules"
# $ go mod vendor
# $ git add -f vendor
# $ git commit -n --no-post-rewrite -m "add go modules by go mod vendor"

%setup
%if_disabled tarball
%patch1 -p1
mkdir -p node_modules/esbuild/bin
ln -s %_bindir/esbuild node_modules/esbuild/bin/esbuild
%else
%patch3 -p1
%endif
%patch2 -p1

%build
export BUILDDIR="$PWD/.gopath"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export LDFLAGS="-X code.gitea.io/gitea/modules/setting.CustomConf=%_sysconfdir/%name/app.ini \
                -X code.gitea.io/gitea/modules/setting.CustomPath=%_localstatedir/%name/custom \
                -X code.gitea.io/gitea/modules/setting.AppWorkPath=%_localstatedir/%name"

TAGS="bindata timetzdata sqlite sqlite_unlock_notify pam" GITEA_VERSION=%version %make all

%install
mkdir -p %buildroot%_localstatedir/%name
mkdir -p %buildroot%_logdir/%name
install -Dm 0755 %name %buildroot%_bindir/%name
install -Dm 0644 %SOURCE2 %buildroot%_unitdir/%name.service
mkdir -p %buildroot%_sysconfdir/systemd/system/gitea.service.d
install -Dm 0644 %SOURCE3 %buildroot%_sysconfdir/systemd/system/gitea.service.d/port.conf
install -Dm 0660 custom/conf/app.example.ini %buildroot%_sysconfdir/%name/app.ini

mkdir -p %buildroot%_docdir/%name
install -Dm 0644 custom/conf/app.example.ini %buildroot%_docdir/%name/default-app.ini
install -Dm 0644 %SOURCE4 %buildroot%_docdir/%name/

# install docs
mkdir -p %buildroot%_man1dir
%buildroot%_bindir/%name docs --man > %buildroot%_man1dir/%name.1

# install completions
install -D -p -m 0644 contrib/autocompletion/bash_autocomplete %buildroot%_datadir/bash-completion/completions/%name
install -D -p -m 0644 contrib/autocompletion/zsh_autocomplete %buildroot%_datadir/zsh/site-functions/_%name

%pre
groupadd -r -f %name 2>/dev/null ||:
useradd -r -g %name -c 'Gitea daemon' \
        -s /bin/bash  -d %_localstatedir/%name %name 2>/dev/null ||:

%post
%post_systemd %name.service

%preun
%preun_systemd %name.service

%files
%doc *.md
%_docdir/%name
%_bindir/%name
%dir %attr(0750,%name,%name) %_localstatedir/%name
%dir %attr(0770,root,%name) %_logdir/%name
%dir %_sysconfdir/%name
%config(noreplace) %attr(0660,root,%name) %_sysconfdir/%name/app.ini
%dir %_sysconfdir/systemd/system/gitea.service.d
%config(noreplace) %_sysconfdir/systemd/system/gitea.service.d/port.conf
%_unitdir/%name.service
%_man1dir/*
%_datadir/bash-completion/completions/gitea
%_datadir/zsh/site-functions/_gitea


%changelog
