%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: gmp
Version: 6.3.0
Release: alt1

Summary: GNU MP arbitrary precision arithmetic library
License: LGPLv3+
Group: System/Libraries
Url: http://gmplib.org/

# https://gmplib.org/download/gmp/gmp-%version.tar.xz
Source: gmp-%version.tar
Patch: gmp-%version-%release.patch

# Automatically added by buildreq on Mon Aug 28 2023
# optimized out: glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config libgpg-error libstdc++-devel perl perl-Encode perl-Text-Unidecode perl-Unicode-EastAsianWidth perl-Unicode-Normalize perl-libintl perl-parent sh4
BuildRequires: flex gcc-c++ makeinfo

%def_disable static
%def_enable cxx
%ifarch %ix86
%def_enable fat
%else
%def_disable fat
%endif

%define libgmp libgmp10
%define libgmpxx libgmpxx4

%description
GNU MP is a library for arbitrary precision arithmetic, operating on
signed integers, rational numbers, and floating point numbers.  It has
a rich set of functions, and the functions have a regular interface.

%package -n %libgmp
Summary: GNU MP arbitrary precision arithmetic library
Group: System/Libraries
Provides: gmp = %version, libgmp = %version
Obsoletes: gmp < %version

%package -n libgmp-devel
Summary: Development GNU MP arbitrary precision arithmetic library
Group: Development/C
Requires: %libgmp = %version-%release
Provides: gmp-devel = %version
Obsoletes: gmp-devel

%package -n libgmp-devel-static
Summary: Static GNU MP arbitrary precision arithmetic library
Group: Development/C
Requires: libgmp-devel = %version-%release

%package -n %libgmpxx
Summary: C++ bindings for the GNU MP arbitrary precision arithmetic library
Group: Development/C++
Requires: %libgmp = %version-%release
Provides: libgmp_cxx = %version
Obsoletes: libgmp_cxx

%package -n libgmpxx-devel
Summary: Development C++ bindings for the GNU MP arbitrary precision arithmetic library
Group: Development/C++
Requires: %libgmpxx = %version-%release
Requires: libgmp-devel = %version-%release
Provides: libgmp_cxx-devel = %version
Obsoletes: libgmp_cxx-devel

%package -n libgmpxx-devel-static
Summary: Static C++ bindings for the GNU MP arbitrary precision arithmetic library
Group: Development/C++
Requires: libgmpxx-devel = %version-%release
Requires: libgmp-devel-static = %version-%release
Provides: libgmp_cxx-devel-static = %version
Obsoletes: libgmp_cxx-devel-static

%description -n %libgmp
GNU MP is a library for arbitrary precision arithmetic, operating on
signed integers, rational numbers, and floating point numbers.  It has
a rich set of functions, and the functions have a regular interface.

GNU MP is designed to be as fast as possible, both for small operands
and huge operands.  The speed is achieved by using fullwords as the
basic arithmetic type, by using fast algorithms, with carefully
optimized assembly code for the most common inner loops for lots of
CPUs, and by a general emphasis on speed (instead of simplicity or
elegance).

GNU MP is believed to be faster than any other similar library.
Its advantage increases with operand sizes for certain operations,
since GNU MP in many cases has asymptotically faster algorithms.

%description -n libgmp-devel
This package contains libraries, header files and documentation required
for development with the GNU MP arbitrary precision arithmetic library.

%description -n libgmp-devel-static
This package contains static libraries required for development of
statically linked applications with the GNU MP arbitrary precision
arithmetic library.

%description -n %libgmpxx
This package contains C++ bindings for the GNU MP arbitrary precision
arithmetic library.

%description -n libgmpxx-devel
This package contains libraries, header files and documentation required
for development C++ applications with the GNU MP arbitrary precision
arithmetic library.

%description -n libgmpxx-devel-static
This package contains static libraries required for development of
statically linked C++ applications with the GNU MP arbitrary precision
arithmetic library.

%prep
%setup
%patch -p1

rm -f doc/gmp.info*

%build
# -ffat-lto-objects is needed even if static libraries are disabled
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
%autoreconf
%configure %{subst_enable static} %{subst_enable cxx} %{subst_enable fat}
LANG=C awk 'NR>=3&&$1=="#define"&&$2~/^[a-z_0-9]+$/&&$3~/^__/{print gensub("^__MPN\\(([^)]+)\\)","__gmpn_\\1",1,$3)}' \
	gmp.h > libgmp.sym
sed -n 's/^[^ ]\+ \(__gmp_[^ ]\+\) .*/\1/p' rand/randmt.h >> libgmp.sym
# Extra symbols required by libgmpxx, gmp test suite, ocaml-zarith, and gmp-ecm package:
cat >>libgmp.sym <<'EOF'
__gmp_allocate_func
__gmp_asprintf_final
__gmp_asprintf_memory
__gmp_asprintf_reps
__gmp_assert_fail
__gmp_binvert_limb_table
__gmp_default_allocate
__gmp_default_free
__gmp_default_reallocate
__gmp_doprnt_integer
__gmp_doprnt_mpf2
__gmp_fib_table
__gmp_free_func
__gmp_randinit_mt_noseed
__gmp_rands
__gmp_rands_initialized
__gmp_reallocate_func
__gmp_tmp_reentrant_alloc
__gmp_tmp_reentrant_free
__gmpn_addaddmul_1msb0
__gmpn_bases
__gmpn_bdiv_qr
__gmpn_bdiv_qr_itch
__gmpn_broot
__gmpn_brootinv
__gmpn_clz_tab
__gmpn_cpuvec
__gmpn_cpuvec_init
__gmpn_cpuvec_initialized
__gmpn_dcpi1_bdiv_q
__gmpn_dcpi1_bdiv_qr
__gmpn_dcpi1_div_q
__gmpn_dcpi1_div_qr
__gmpn_dcpi1_divappr_q
__gmpn_div_q
__gmpn_divexact
__gmpn_dump
__gmpn_fft_best_k
__gmpn_fib2_ui
__gmpn_fib2m
__gmpn_gcd_22
__gmpn_get_d
__gmpn_hgcd
__gmpn_hgcd_appr
__gmpn_hgcd_appr_itch
__gmpn_hgcd_itch
__gmpn_hgcd_matrix_init
__gmpn_invert
__gmpn_invert_limb
__gmpn_jacobi_base
__gmpn_matrix22_mul
__gmpn_matrix22_mul_itch
__gmpn_mod_1_1p
__gmpn_mod_1_1p_cps
__gmpn_mod_1s_2p
__gmpn_mod_1s_2p_cps
__gmpn_mod_1s_3p
__gmpn_mod_1s_3p_cps
__gmpn_mod_1s_4p
__gmpn_mod_1s_4p_cps
__gmpn_mod_34lsub1
__gmpn_mu_bdiv_q
__gmpn_mu_bdiv_q_itch
__gmpn_mu_bdiv_qr
__gmpn_mu_bdiv_qr_itch
__gmpn_mu_div_q
__gmpn_mu_div_q_itch
__gmpn_mu_div_qr
__gmpn_mu_div_qr_itch
__gmpn_mu_divappr_q
__gmpn_mu_divappr_q_itch
__gmpn_mul_basecase
__gmpn_mul_fft
__gmpn_mullo_basecase
__gmpn_mullo_n
__gmpn_mulmid
__gmpn_mulmod_bknp1
__gmpn_mulmod_bnm1
__gmpn_mulmod_bnm1_next_size
__gmpn_powlo
__gmpn_preinv_divrem_1
__gmpn_sbpi1_bdiv_q
__gmpn_sbpi1_bdiv_qr
__gmpn_sbpi1_bdiv_r
__gmpn_sbpi1_div_q
__gmpn_sbpi1_div_qr
__gmpn_sbpi1_divappr_q
__gmpn_sqr_basecase
__gmpn_sqrlo
__gmpn_sqrmod_bknp1
__gmpn_sqrmod_bnm1
__gmpn_sqrmod_bnm1_next_size
__gmpn_toom22_mul
__gmpn_toom2_sqr
__gmpn_toom32_mul
__gmpn_toom33_mul
__gmpn_toom3_sqr
__gmpn_toom42_mul
__gmpn_toom43_mul
__gmpn_toom44_mul
__gmpn_toom4_sqr
__gmpn_toom52_mul
__gmpn_toom53_mul
__gmpn_toom54_mul
__gmpn_toom62_mul
__gmpn_toom63_mul
__gmpn_toom6_sqr
__gmpn_toom6h_mul
__gmpn_toom8_sqr
__gmpn_toom8h_mul
__gmpz_divexact_gcd
__gmpz_lucas_mod
EOF
sort -u -o libgmp.sym libgmp.sym
%make_build

%install
%makeinstall_std
install -pm644 gmp-mparam.h rand/randmt.h %buildroot%_includedir/

%check
%make_build -k check

%files -n %libgmp
%doc AUTHORS README NEWS
%_libdir/libgmp.so.*

%files -n libgmp-devel
%_libdir/libgmp.so
%_includedir/*
%{?_enable_cxx:%exclude %_includedir/*xx*}
%_infodir/*.info*
%_pkgconfigdir/gmp.pc

%if_enabled static
%files -n libgmp-devel-static
%_libdir/libgmp.a
%endif #static

%if_enabled cxx
%files -n %libgmpxx
%_libdir/*xx*.so.*

%files -n libgmpxx-devel
%_libdir/*xx*.so
%_includedir/*xx*
%_pkgconfigdir/gmpxx.pc
%endif #cxx

%if %{enabled cxx} && %{enabled static}
%files -n libgmpxx-devel-static
%_libdir/*xx*.a
%endif #cxx && static

%changelog
