%define _unpackaged_files_terminate_build 1

Name: gnokii
Version: 0.6.31
Release: alt3

Summary: Unix tool suite for Nokia mobile phones
Group: Communications
License: GPL-2.0-or-later
Url: https://www.gnokii.org/

Source: %name-%version.tar
Patch: %name-%version-%release.patch
Patch1: %name-0.6.31-alt-mysql8-transition.patch

Requires: lib%name = %EVR

# Automatically added by buildreq on Fri Oct 10 2008 (-bi)
BuildRequires: flex intltool libMySQL-devel libXpm-devel libbluez-devel libgtk+2-devel libical-devel libncurses-devel libpcsclite-devel libsqlite3-devel libreadline-devel libusb-compat-devel postgresql-devel

%description
Gnokii is a Unix tool suite for Nokia mobile phones.

You should be in 'uucp' group to use it with serial cables.

%package -n x%name
Summary: Unix tool suite for Nokia mobile phones
Group: Communications
Requires: %name = %EVR
Requires: gnokii-artwork

%description -n x%name
xgnokii is a graphical tool for Nokia mobile phones

%package -n lib%name
Summary: Library for gnokii
Group: System/Libraries

%description -n lib%name
You will need libgnokii to run gnokii.

%package -n lib%name-devel
Summary: Development files for gnokii
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
Install gnokii-devel if you want to develop or compile applications using
gnokii API.

%package smsd
Summary: Daemon for handling incoming and outgoing SMSes using libgnokii
Group: Communications
Requires: lib%name = %EVR

%description smsd
The SMSD (SMS daemon) program is intended for receiving and sending
SMSes with plain file plugin.

%package smsd-mysql
Summary: MySQL plugin for gnokii-smsd
Group: Communications
Requires: %name-smsd = %EVR

%description smsd-mysql
MySQL plugin for gnokii-smsd.

%package smsd-pq
Summary: PostgreSQL plugin for gnokii-smsd
Group: Communications
Requires: %name-smsd = %EVR

%description smsd-pq
PostgreSQL plugin for gnokii-smsd.

%package smsd-sqlite
Summary: SQLite plugin for gnokii-smsd
Group: Communications
Requires: %name-smsd = %EVR

%description smsd-sqlite
SQLite plugin for gnokii-smsd.

%prep
%setup
%patch -p1
%patch1 -p0

%build
# SMP-incompatible
%define __nprocs 1
#add_optflags %optflags_shared
export lt_cv_prog_cc_static_works=no

%add_optflags -fgnu89-inline
%autoreconf
%configure \
	--disable-static \
	--disable-rpath \
	--with-x \
	--enable-nls \
	--enable-security \
	--enable-libusb \
	--enable-irda \
	--enable-bluetooth \
	--enable-libical \
	--enable-libpcsclite \
	--enable-smsd \
	#
%make_build

pushd xgnokii
%make_build
popd

%install
%makeinstall_std

pushd xgnokii
%makeinstall_std
popd

mv %buildroot%_defaultdocdir/%name %buildroot%_docdir/%name-%version
install -pm644 ChangeLog %buildroot%_docdir/%name-%version/

chmod +x %buildroot%_bindir/*

mkdir -p %buildroot%_datadir/xgnokii
mkdir -p %buildroot%_sysconfdir
sed 's,/usr/local/sbin,%_sbindir,g' \
	< Docs/sample/gnokiirc \
	> %buildroot%_sysconfdir/gnokiirc

rm %buildroot%_libdir/smsd/*.la

%find_lang %name

%files -f %name.lang
%docdir %_defaultdocdir/%name-%version
%dir %_defaultdocdir/%name-%version
%doc %_defaultdocdir/%name-%version/*
%config(noreplace) %_sysconfdir/gnokiirc
%_bindir/gnokii
%_bindir/gnokiid
%_bindir/sendsms
%_sbindir/mgnokiidev
%_man1dir/gnokii.1*
%_man1dir/sendsms.1*
%_man8dir/gnokiid.8*
%_man8dir/mgnokiidev.8*

%files -n x%name
%_bindir/xgnokii
%dir %_datadir/xgnokii
%_desktopdir/xgnokii.desktop
%_man1dir/xgnokii.1*

%files -n lib%name
%_libdir/lib%name.so.*

%files -n lib%name-devel
%dir %_includedir/%name
%_includedir/gnokii.h
%_includedir/%name/*
%_libdir/lib%name.so
%_pkgconfigdir/gnokii.pc
%_pkgconfigdir/xgnokii.pc

%files smsd
%doc smsd/README
%doc smsd/sms.tables.mysql.sql
%doc smsd/sms.tables.pq.sql
%doc smsd/sms.tables.sqlite.sql
%_bindir/smsd
%_man8dir/smsd.8*
%dir %_libdir/smsd
%_libdir/smsd/libsmsd_file.so

%files smsd-mysql
%_libdir/smsd/libsmsd_mysql.so

%files smsd-pq
%_libdir/smsd/libsmsd_pq.so

%files smsd-sqlite
%_libdir/smsd/libsmsd_sqlite.so

%changelog
