%def_disable snapshot

%define ver_major 1.18
%def_with exiv2
%def_with taglib
%def_with poppler
%def_with libgsf
%def_with samba

%def_enable check

Name: gnome-commander
Version: %ver_major.2
Release: alt1

%define xdg_name org.gnome.%name

Summary: A Gnome file manager similar to the Norton Commander (TM)
License: GPL-2.0
Group: File tools
Url: https://gcmd.github.io

Vcs: https://gitlab.gnome.org/GNOME/gnome-commander.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define gtk_ver 3.24

Requires: dconf xdg-utils
Requires: %_bindir/gio gvfs-backends
Requires: file-roller

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson flex gcc-c++
BuildRequires: yelp-tools desktop-file-utils /usr/bin/appstreamcli
BuildRequires: libgtk+3-devel >= %gtk_ver libgnome-keyring-devel
%{?_with_exiv2:BuildRequires: libexiv2-devel}
%{?_with_taglib:BuildRequires: libtag-devel}
%{?_with_poppler:BuildRequires: libpoppler-glib-devel}
%{?_with_libgsf:BuildRequires: libgsf-devel}
%{?_with_samba:BuildRequires: libsmbclient-devel}
%{?_enable_check:BuildRequires: xvfb-run libgtest-devel}

%description
GNOME Commander is a two-pane graphical file manager for the GNOME
desktop environment. It features separate tabs for each pane,
setting up custom device buttons, bookmark manager, fully integrated
commandline, file quick search, an internal image viewer, a powerful
batch renaming tool, and FTP and Samba access.

%prep
%setup
%ifarch %e2k
# workaround for EDG frontend
sed -i.e2k "/g_autofree gchar/{s|g_autofree gchar|g_autofree_edg(gchar)|;s|\*||g}" src/gnome-cmd-data.cc
%endif

%build
%meson
%meson_build

%install
%meson_install
rm -f %buildroot%_libdir/libgcmd.a

%find_lang --with-gnome %name

%check
xvfb-run %__meson_test

%files -f %name.lang
%_bindir/*
%_libdir/%name/
%_datadir/%name/
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.enums.xml
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/*/apps/*.svg
%_datadir/pixmaps/%name/
%_datadir/metainfo/%xdg_name.appdata.xml
%_man1dir/*
%doc AUTHORS NEWS README* TODO doc/*.txt

%exclude %_datadir/%name/internal_viewer_hacking.txt
%exclude %_datadir/%name/keys.txt


%changelog
