%def_disable snapshot

%define _unpackaged_files_terminate_build 1
%define ver_major 47
%define beta %nil
%define xdg_name org.gnome.font-viewer

Name: gnome-font-viewer
Version: %ver_major.0
Release: alt1%beta

Summary: The GNOME Font Viewer
Group: Graphical desktop/GNOME
License: GPL-2.0-or-later
Url: https://apps.gnome.org/FontViewer

Vcs: https://gitlab.gnome.org/GNOME/gnome-font-viewer.git

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.56.0
%define gtk4_ver 4.10
%define adwaita_ver 1.5

BuildRequires(pre): rpm-macros-meson rpm-build-gnome
BuildRequires: meson /usr/bin/appstreamcli
BuildRequires: libgio-devel >= %glib_ver libgtk4-devel >= %gtk4_ver
BuildRequires: fontconfig-devel libfreetype-devel
BuildRequires: libharfbuzz-devel libfribidi-devel
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver

%description
GNOME Font Viewer is a simple application to preview fonts.

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_bindir/gnome-thumbnail-font
%_desktopdir/%xdg_name.desktop
%_datadir/thumbnailers/%name.thumbnailer
%_datadir/dbus-1/services/%xdg_name.service
%_iconsdir/hicolor/*/*/%{xdg_name}*.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%doc NEWS

%changelog
