%def_enable snapshot

%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec

%define _name 2048
%define __name gnome-%_name
%define ver_major 3.38
%define xdg_name org.gnome.TwentyFortyEight

Name: gnome-games-%_name
Version: %ver_major.2
Release: alt2

Summary: A 2048 clone for GNOME
Group: Games/Boards
License: %gpl3plus
Url: https://wiki.gnome.org/Apps/2048

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%__name/%ver_major/%__name-%version.tar.xz
%else
Source: %__name-%version.tar
%endif

Provides:  %__name = %version-%release

%define gtk_ver 3.22.3
%define clutter_gtk_ver 1.6
%define gee_ver 0.14
%define libgames_ver 1.2.0
%define vala_ver 0.24

BuildRequires(pre): rpm-macros-meson rpm-build-licenses
BuildRequires: meson yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: vala-tools >= %vala_ver
BuildRequires: libgtk+3-devel >= %gtk_ver libclutter-gtk3-devel >= %clutter_gtk_ver
BuildRequires: libgee0.8-devel >= %gee_ver libgnome-games-support-devel >= %libgames_ver

%description
Move the tiles until you obtain the 2048 tile.

%prep
%setup -n %__name-%version
sed -E -i "s/^[[:space:]]*'(desktop|appdata)-file'\,//" data/meson.build

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %__name

%files -f gnome-%_name.lang
%_bindir/%__name
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_man6dir/%__name.6.*
%_datadir/metainfo/%xdg_name.appdata.xml

%changelog
