%def_disable snapshot
%define _unpackaged_files_terminate_build 1

%define _name robots
%define xdg_name org.gnome.Robots
%define __name gnome-%_name
%define ver_major 41
%define _libexecdir %_prefix/libexec

%def_disable bootstrap

Name: gnome-games-%_name
Version: %ver_major.2
Release: alt1

Summary: Gnome version of robots game for BSD games collection
License: GPL-3.0-or-later
Group: Games/Boards
Url: https://wiki.gnome.org/Apps/Robots

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%__name/%ver_major/%__name-%version.tar.xz
%else
Source: %__name-%version.tar
%endif
Source1: %__name-%version-cargo.tar

Provides:  %__name = %EVR
Obsoletes: gnome-games-gnobots
Provides:  gnome-games-gnobots = %EVR

%define glib_ver 2.82
%define gtk_ver 4.16
%define adw_ver 1.6
%define rsvg_ver 2.60

# for glycin
Requires: bubblewrap glycin-loaders

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson rust-cargo yelp-tools
BuildRequires: gsettings-desktop-schemas-devel
BuildRequires: libgio-devel >= %glib_ver pkgconfig(gtk4) >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: pkgconfig(librsvg-2.0) >= %rsvg_ver pkgconfig(libxml-2.0)
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils}

%description
GNOME Robots is a development of the original Gnome Robots game which
was itself based on the text based robots game which can be found on a
number of UNIX systems, and comes with the BSD games package on Linux
systems.

%prep
%setup -n %__name-%version %{?_disable_bootstrap:-a1}
%{?_enable_bootstrap:
mkdir .cargo
cargo vendor | sed 's/^directory = ".*"/directory = "vendor"/g' > .cargo/config.toml
tar -cf %_sourcedir/%__name-%version-cargo.tar .cargo/ vendor/}

%build
%meson \
    -Dprofile=release
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome %__name

%check
%__meson_test

%files -f gnome-%_name.lang
%_bindir/%__name
%_desktopdir/%xdg_name.desktop
%_datadir/%__name
%_iconsdir/hicolor/*/*/*.*
%_man6dir/%__name.*
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.metainfo.xml

%changelog
