%def_enable snapshot
%define _libexecdir %_prefix/libexec

%define ver_major 3.35
%define xdg_name org.gnome.MultiWriter

Name: gnome-multi-writer
Version: %ver_major.90
Release: alt2

Summary: Write an ISO file to multiple USB devices at once
Group: Archiving/Backup
License: GPL-2.0
Url: https://wiki.gnome.org/Apps/MultiWriter

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: gnome-icon-theme-extras dconf polkit

%define gtk_ver 3.12.0
%define gusb_ver 0.2.7

BuildRequires(pre): meson
BuildRequires: libappstream-glib-devel docbook-utils yelp-tools
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libgusb-devel >= %gusb_ver
BuildRequires: libudisks2-devel libgudev-devel libcanberra-gtk3-devel
BuildRequires: gobject-introspection-devel
BuildRequires: libpolkit-devel

%description
GNOME MultiWriter can be used to write an ISO file to multiple
USB devices simultaneously.

%prep
%setup

%build
%add_optflags %(getconf LFS_CFLAGS)
%meson
%meson_build

%install
%meson_install
%find_lang %name

%files -f %name.lang
%_bindir/%name
%_libexecdir/%name-probe
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/polkit-1/actions/%xdg_name.policy
%_iconsdir/hicolor/*/apps/*
%_man1dir/%name.1.*
%_datadir/metainfo/%xdg_name.appdata.xml
%doc README.md AUTHORS RELEASE


%changelog
