%define ver_major 43
%define xdg_name org.gnome.PowerStats

Name: gnome-power-manager
Version: %ver_major.0
Release: alt1

Summary: GNOME Power management tools
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: http://www.gnome.org/projects/gnome-power-manager/

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

Requires: upower >= 0.9.7

BuildRequires(pre): rpm-build-gnome rpm-macros-meson

BuildRequires: meson
BuildRequires: glib2-devel >= 2.46.0
BuildRequires: libgtk+3-devel >= 3.3.8
BuildRequires: libupower-devel >= 0.99.8
BuildRequires: /usr/bin/appstream-util
# for docbook2man
BuildRequires: docbook-utils

%description
A tool for viewing present and historical battery usage and related
statistics. Originally part of GNOME Power Manager and remained as a
stand alone program after the rest was merged into gnome-settings-daemon.

%prep
%setup

%build
%meson \
    -Denable-tests=true
%meson_build

%check
%meson_test

%install
%meson_install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/gnome-power-statistics
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/*/*.png
%_iconsdir/hicolor/*/*/*.svg
%config %_datadir/glib-2.0/schemas/org.gnome.power-manager.gschema.xml
%_man1dir/*.1.*
%_datadir/metainfo/%xdg_name.appdata.xml
%doc README* AUTHORS


%changelog
