%def_disable snapshot

%define ver_major 3.56
%define xdg_name org.gnome.Terminal
%define _libexecdir %_prefix/libexec
%define nautilus_extdir %_libdir/nautilus/extensions-4

%def_with nautilus

Name: gnome-terminal
Version: %ver_major.2
Release: alt1

Summary: GNOME Terminal
License: GPL-3.0-or-later
Group: Terminals
Url: https://www.gnome.org

Vcs: https://gitlab.gnome.org/GNOME/gnome-terminal.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.68
%define gtk_ver 3.24
%define handy_ver 1.6
%define vte_ver 0.80.0

Provides: xvt
Provides: x-terminal-emulator

Requires(pre): libvte3 >= %vte_ver
Requires: common-licenses
Requires: dconf gnome-icon-theme

BuildRequires(pre): rpm-macros-meson rpm-build-gnome rpm-macros-alternatives
BuildRequires: meson gcc-c++
BuildRequires: yelp-tools desktop-file-utils libappstream-glib-devel docbook-style-xsl xsltproc
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver
BuildRequires: libvte3-devel >= %vte_ver
BuildRequires: gsettings-desktop-schemas-devel libSM-devel
BuildRequires: libdconf-devel libuuid-devel
BuildRequires: libpcre2-devel
%{?_with_nautilus:BuildRequires: pkgconfig(libnautilus-extension-4)}
# %%_datadir/dbus-1/interfaces/org.gnome.ShellSearchProvider2.xml
Buildrequires: gnome-shell-data

%description
GNOME terminal emulator application.

%package nautilus
Summary: Nautilus extension for the GNOME Terminal
Group: Graphical desktop/GNOME
Requires: %name = %EVR

%description nautilus
This package provides integration with the GNOME Terminal for the
Nautilus file manager.

%prep
%setup

# license
%__rm -f COPYING
%__ln_s -f %_licensedir/GPL-3 COPYING

%build
%meson \
    %{?_without_nautilus:-Dnautilus_extension=false}
%meson_build

%install
%meson_install

# alternatives (xterm -- 40)
mkdir -p %buildroot%_altdir
cat >%buildroot%_altdir/%name <<EOF
%_bindir/xvt	%_bindir/%name	39
%_bindir/x-terminal-emulator	%_bindir/%name	39
EOF

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_libexecdir/%name-server
%_libexecdir/%name-preferences
%_prefix/lib/systemd/user/%name-server.service
%_desktopdir/%xdg_name.desktop
%_desktopdir/%xdg_name.Preferences.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/xdg-terminals/%xdg_name.desktop
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%dir %_libdir/%name
%_libdir/%name/gschemas.compiled
%_datadir/gnome-shell/search-providers/%name-search-provider.ini
%_iconsdir/hicolor/*/apps/%{xdg_name}*.*
%_datadir/metainfo/%xdg_name.metainfo.xml
%_man1dir/%name.1*
%_altdir/%name
%doc --no-dereference COPYING
%doc README*

%if_with nautilus
%files nautilus
%nautilus_extdir/libterminal-nautilus.so
%_datadir/metainfo/%xdg_name.Nautilus.metainfo.xml
%endif

%changelog
