
%def_disable gpgutils
%define _localstatedir /var
%def_disable beta

Name: gnupg2-gostcrypto
Version: 2.2.19
Release: alt3

Group: Text tools
Summary: The GNU Privacy Guard suite
License: GPLv3+
Url: http://www.gnupg.org/

# ftp://ftp.gnupg.org/gcrypt/gnupg/gnupg-%version.tar.bz2
Source0: gnupg-%version.tar
Source1: gnupg-agent.sh
Source2: gnupg-agent-wrapper.sh

%define docdir %_docdir/gnupg-%version

Provides: newpg = %version-%release
Obsoletes: newpg < %version-%release
Provides: dirmngr = %version-%release
Obsoletes: dirmngr < %version-%release
Provides: gnupg-agent = %version-%release
Provides: gnupg2 = %version-%release
Provides: gnupg2-agent = %version-%release
Provides: gnupg2-gpg = %version-%release
Provides: gnupg2-common = %version-%release
Obsoletes: gnupg2-agent < %version-%release
Obsoletes: gnupg2-common < %version-%release
Obsoletes: gnupg2 < %version
Conflicts: gnupg2 >= %version

# due to "enable -f /usr/lib/bash/lockf lockf"
Requires: bash-builtin-lockf >= 0:0.2

# due to passing OPTION allow-external-password-cache
Conflicts: pinentry < 0.9.2
Conflicts: pinentry-common < 0.9.2
Conflicts: gnupg-pkcs11-scd <= 0.9.2-alt5

# FC
Patch11: gnupg-2.2.17-insttools.patch
Patch12: gnupg-2.1.19-exponential.patch
Patch13: gnupg-2.1.10-secmem.patch
Patch14: gnupg-2.1.1-ocsp-keyusage.patch
Patch15: gnupg-2.1.1-fips-algo.patch
Patch16: gnupg-2.1.21-large-rsa.patch
Patch17: gnupg-2.2.0-file-is-digest.patch
# ALT
Patch100: alt-revision.patch
Patch101: alt-xloadimage.patch
Patch102: alt-agent-fix-password-request.patch
Patch103: alt-texinfo.patch

# GOST patch/requires/provides
%define gostversion 2.0.3
Patch18: %name-%version-gost-common.patch
Patch19: %name-%version-gost-agent.patch
Patch20: %name-%version-gost-g10.patch
Patch21: %name-%version-gost-sm.patch
Patch22: %name-%version-gost-dirmngr.patch
Requires: libgcrypt(vko) >= 2.0.0
Requires: libgcrypt(imit) >= 1.0.0
Requires: libgcrypt(keymeshing) >= 1.0.0
Requires: libksba(gost) >= 2.0.0
Provides: gnupg2(gost) = %gostversion

# Issuers patch/provides
%define issuersconfversion 1.0.1
Patch23: %name-%version-issuersconf.patch
Provides: gnupg2(issuersconf) = %issuersconfversion

BuildRequires: libgcrypt-gost-devel >= 1.8.5-alt2
BuildRequires: libksba-gost-devel >= 1.3.6-alt12
BuildRequires: libassuan-devel
BuildRequires: libgnutls-devel libnpth-devel
BuildRequires: bzlib-devel libcurl-devel libldap-devel
BuildRequires: libreadline-devel zlib-devel libusb-devel pkgconfig(sqlite3)
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
GnuPG is GNU's tool for secure communication and data storage.  It can
be used to encrypt data and to create digital signatures.  It includes
an advanced key management facility and is compliant with the proposed
OpenPGP Internet standard as described in RFC2440 and the S/MIME
standard as described by several RFCs.

GnuPG 2.0 is a newer version of GnuPG with additional support for
S/MIME.  It has a different design philosophy that splits
functionality up into several modules.

%prep
%setup -n gnupg-%version
%patch11 -p2
#%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch101 -p1
#%patch102 -p1
%patch103 -p1
rm doc/*.info*

# Version revision
%patch100 -p2
%if_disabled beta
sed -i -e 's/@BETA@/no/' configure.ac
%else
sed -i -e 's/@BETA@/yes/' configure.ac
%endif
sed -i -e 's/@REVISION@/gost-%gostversion/' -e 's/@REVISION_DESC@/ALT/' configure.ac

%build
# Need to regenerate the build files in order to include the new
# GOST modules:
%autoreconf

%add_optflags -fno-strict-aliasing -fcommon
%configure \
	--enable-gpg-is-gpg2 \
	--enable-g13 \
	--enable-large-secmem \
	--disable-rpath \
	--with-capabilities \
	--enable-symcryptrun \
	--with-mailprog=%_sbindir/sendmail \
	--with-pinentry-pgm=%_bindir/pinentry \
	--libexecdir=%_libexecdir/gnupg \
	--with-default-trust-store-file=%_datadir/ca-certificates/ca-bundle.crt \
	--docdir=%docdir
%make_build MAKEINFOFLAGS=--no-split

%install
%makeinstall_std

mkdir -p %buildroot/usr/lib/systemd/user/
install -m 0644 doc/examples/systemd-user/dirmngr.service %buildroot/usr/lib/systemd/user
install -m 0644 doc/examples/systemd-user/dirmngr.socket  %buildroot/usr/lib/systemd/user
install -m 0644 doc/examples/systemd-user/gpg-agent-browser.socket  %buildroot/usr/lib/systemd/user/
install -m 0644 doc/examples/systemd-user/gpg-agent-extra.socket    %buildroot/usr/lib/systemd/user/
install -m 0644 doc/examples/systemd-user/gpg-agent-ssh.socket      %buildroot/usr/lib/systemd/user/
install -m 0644 doc/examples/systemd-user/gpg-agent.service         %buildroot/usr/lib/systemd/user/
install -m 0644 doc/examples/systemd-user/gpg-agent.socket          %buildroot/usr/lib/systemd/user/

install -pDm755 %_sourcedir/gnupg-agent.sh \
	%buildroot%_sysconfdir/profile.d/gnupg-agent.sh
sed -i 's|@LIBEXECDIR@|%_libexecdir|g' \
	%buildroot%_sysconfdir/profile.d/gnupg-agent.sh
install -pDm755 %_sourcedir/gnupg-agent-wrapper.sh \
	%buildroot%_libexecdir/gnupg/gnupg-agent-wrapper

install -pm644 AUTHORS NEWS THANKS %buildroot%docdir/

%find_lang gnupg2

%check
%make_build -k check

%define _unpackaged_files_terminate_build 1

%files -f gnupg2.lang
%config %_sysconfdir/profile.d/gnupg-agent.sh
%_bindir/*
%if_disabled gpgutils
%exclude %_bindir/gpg-zip
%exclude %_bindir/gpgsplit
%endif
%_sbindir/*
%_libexecdir/gnupg/
/usr/lib/systemd/user/*.*
%_datadir/gnupg/
%_infodir/*.info*
%_mandir/man?/*
#exclude %_man1dir/gpg-zip.*
%docdir

%changelog
